/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.Invoice;
import dev.vality.swag_webhook_events.model.Payment;
import dev.vality.swag_webhook_events.model.Refund;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Schema(name="RefundSucceeded", description="Event of successful completion of a refund")
public class RefundSucceeded
extends Event {
    @JsonProperty(value="invoice")
    private Invoice invoice;
    @JsonProperty(value="payment")
    private Payment payment;
    @JsonProperty(value="refund")
    private Refund refund;

    public RefundSucceeded invoice(Invoice invoice) {
        this.invoice = invoice;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="invoice", required=true)
    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public RefundSucceeded payment(Payment payment) {
        this.payment = payment;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="payment", required=true)
    public Payment getPayment() {
        return this.payment;
    }

    public void setPayment(Payment payment) {
        this.payment = payment;
    }

    public RefundSucceeded refund(Refund refund) {
        this.refund = refund;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="refund", required=true)
    public Refund getRefund() {
        return this.refund;
    }

    public void setRefund(Refund refund) {
        this.refund = refund;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefundSucceeded refundSucceeded = (RefundSucceeded)o;
        return Objects.equals(this.invoice, refundSucceeded.invoice) && Objects.equals(this.payment, refundSucceeded.payment) && Objects.equals(this.refund, refundSucceeded.refund) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.invoice, this.payment, this.refund, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefundSucceeded {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    invoice: ").append(this.toIndentedString(this.invoice)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    refund: ").append(this.toIndentedString(this.refund)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

