/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="PaymentTerminalReceiptInfo", description="Payment Terminal Receipt")
public class PaymentTerminalReceiptInfo {
    @JsonProperty(value="shortPaymentId")
    private String shortPaymentId;
    @JsonProperty(value="due")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime due;

    public PaymentTerminalReceiptInfo shortPaymentId(String shortPaymentId) {
        this.shortPaymentId = shortPaymentId;
        return this;
    }

    @NotNull
    @Schema(name="shortPaymentId", description="Short payment id", required=true)
    public String getShortPaymentId() {
        return this.shortPaymentId;
    }

    public void setShortPaymentId(String shortPaymentId) {
        this.shortPaymentId = shortPaymentId;
    }

    public PaymentTerminalReceiptInfo due(OffsetDateTime due) {
        this.due = due;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="due", description="Payment closing date and time", required=true)
    public OffsetDateTime getDue() {
        return this.due;
    }

    public void setDue(OffsetDateTime due) {
        this.due = due;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentTerminalReceiptInfo paymentTerminalReceiptInfo = (PaymentTerminalReceiptInfo)o;
        return Objects.equals(this.shortPaymentId, paymentTerminalReceiptInfo.shortPaymentId) && Objects.equals(this.due, paymentTerminalReceiptInfo.due);
    }

    public int hashCode() {
        return Objects.hash(this.shortPaymentId, this.due);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentTerminalReceiptInfo {\n");
        sb.append("    shortPaymentId: ").append(this.toIndentedString(this.shortPaymentId)).append("\n");
        sb.append("    due: ").append(this.toIndentedString(this.due)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

