/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag_webhook_events.model.InvoiceCartLineTaxMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(name="InvoiceCartLine", description="Product or service item")
public class InvoiceCartLine {
    @JsonProperty(value="product")
    private String product;
    @JsonProperty(value="quantity")
    private Long quantity = 1L;
    @JsonProperty(value="price")
    private Long price;
    @JsonProperty(value="cost")
    private Long cost;
    @JsonProperty(value="taxMode")
    private InvoiceCartLineTaxMode taxMode;

    public InvoiceCartLine product(String product) {
        this.product = product;
        return this;
    }

    @NotNull
    @Size(max=1000)
    @Schema(name="product", description="Description of the goods or services offered", required=true)
    public @NotNull @Size(max=1000) String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public InvoiceCartLine quantity(Long quantity) {
        this.quantity = quantity;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @Schema(name="quantity", description="Number of units of goods or services offered in this item ", required=true)
    public @NotNull @Min(value=1L) Long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public InvoiceCartLine price(Long price) {
        this.price = price;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @Schema(name="price", description="The price of the good or service offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ", required=true)
    public @NotNull @Min(value=1L) Long getPrice() {
        return this.price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public InvoiceCartLine cost(Long cost) {
        this.cost = cost;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @Schema(name="cost", description="The total value of the item, taking into account the number of units of goods or services ", required=true)
    public @NotNull @Min(value=1L) Long getCost() {
        return this.cost;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }

    public InvoiceCartLine taxMode(InvoiceCartLineTaxMode taxMode) {
        this.taxMode = taxMode;
        return this;
    }

    @Valid
    @Schema(name="taxMode", required=false)
    public InvoiceCartLineTaxMode getTaxMode() {
        return this.taxMode;
    }

    public void setTaxMode(InvoiceCartLineTaxMode taxMode) {
        this.taxMode = taxMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceCartLine invoiceCartLine = (InvoiceCartLine)o;
        return Objects.equals(this.product, invoiceCartLine.product) && Objects.equals(this.quantity, invoiceCartLine.quantity) && Objects.equals(this.price, invoiceCartLine.price) && Objects.equals(this.cost, invoiceCartLine.cost) && Objects.equals(this.taxMode, invoiceCartLine.taxMode);
    }

    public int hashCode() {
        return Objects.hash(this.product, this.quantity, this.price, this.cost, this.taxMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceCartLine {\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        sb.append("    taxMode: ").append(this.toIndentedString(this.taxMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

