/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag_webhook_events.model.Rational;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Schema(name="CryptoCurrencyTransferInfo", description="Crypto currency transfer request")
public class CryptoCurrencyTransferInfo {
    @JsonProperty(value="cryptoAddress")
    private String cryptoAddress;
    @JsonProperty(value="cryptoAmount")
    private Rational cryptoAmount;
    @JsonProperty(value="cryptoCurrency")
    private String cryptoCurrency;

    public CryptoCurrencyTransferInfo cryptoAddress(String cryptoAddress) {
        this.cryptoAddress = cryptoAddress;
        return this;
    }

    @NotNull
    @Schema(name="cryptoAddress", description="Crypto address", required=true)
    public String getCryptoAddress() {
        return this.cryptoAddress;
    }

    public void setCryptoAddress(String cryptoAddress) {
        this.cryptoAddress = cryptoAddress;
    }

    public CryptoCurrencyTransferInfo cryptoAmount(Rational cryptoAmount) {
        this.cryptoAmount = cryptoAmount;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="cryptoAmount", required=true)
    public Rational getCryptoAmount() {
        return this.cryptoAmount;
    }

    public void setCryptoAmount(Rational cryptoAmount) {
        this.cryptoAmount = cryptoAmount;
    }

    public CryptoCurrencyTransferInfo cryptoCurrency(String cryptoCurrency) {
        this.cryptoCurrency = cryptoCurrency;
        return this;
    }

    @NotNull
    @Schema(name="cryptoCurrency", description="Cryptocurrency type", required=true)
    public String getCryptoCurrency() {
        return this.cryptoCurrency;
    }

    public void setCryptoCurrency(String cryptoCurrency) {
        this.cryptoCurrency = cryptoCurrency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CryptoCurrencyTransferInfo cryptoCurrencyTransferInfo = (CryptoCurrencyTransferInfo)o;
        return Objects.equals(this.cryptoAddress, cryptoCurrencyTransferInfo.cryptoAddress) && Objects.equals(this.cryptoAmount, cryptoCurrencyTransferInfo.cryptoAmount) && Objects.equals(this.cryptoCurrency, cryptoCurrencyTransferInfo.cryptoCurrency);
    }

    public int hashCode() {
        return Objects.hash(this.cryptoAddress, this.cryptoAmount, this.cryptoCurrency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CryptoCurrencyTransferInfo {\n");
        sb.append("    cryptoAddress: ").append(this.toIndentedString(this.cryptoAddress)).append("\n");
        sb.append("    cryptoAmount: ").append(this.toIndentedString(this.cryptoAmount)).append("\n");
        sb.append("    cryptoCurrency: ").append(this.toIndentedString(this.cryptoCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

