/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.constraints.Email;
import javax.validation.constraints.Size;

@Schema(name="ContactInfo", description="Payer's contact information")
public class ContactInfo {
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="phoneNumber")
    private String phoneNumber;

    public ContactInfo email(String email) {
        this.email = email;
        return this;
    }

    @Size(max=100)
    @Email
    @Schema(name="email", description="Email address", required=false)
    public @Size(max=100) @Email String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public ContactInfo phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Schema(name="phoneNumber", description="Mobile phone number with international prefix according to [E.164](https://en.wikipedia.org/wiki/E.164). ", required=false)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactInfo contactInfo = (ContactInfo)o;
        return Objects.equals(this.email, contactInfo.email) && Objects.equals(this.phoneNumber, contactInfo.phoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.phoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactInfo {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

