/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(name="BrowserHTTPInfo", description="Browser http request")
public class BrowserHTTPInfo {
    @JsonProperty(value="requestType")
    private RequestTypeEnum requestType;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="form")
    @Valid
    private Map<String, String> form = null;

    public BrowserHTTPInfo requestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
        return this;
    }

    @NotNull
    @Schema(name="requestType", description="Type of http request", required=true)
    public RequestTypeEnum getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
    }

    public BrowserHTTPInfo url(String url) {
        this.url = url;
        return this;
    }

    @NotNull
    @Size(max=1000)
    @Schema(name="url", description="Uniform Resource Locator", required=true)
    public @NotNull @Size(max=1000) String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public BrowserHTTPInfo form(Map<String, String> form) {
        this.form = form;
        return this;
    }

    public BrowserHTTPInfo putFormItem(String key, String formItem) {
        if (this.form == null) {
            this.form = new HashMap<String, String>();
        }
        this.form.put(key, formItem);
        return this;
    }

    @Schema(name="form", required=false)
    public Map<String, String> getForm() {
        return this.form;
    }

    public void setForm(Map<String, String> form) {
        this.form = form;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowserHTTPInfo browserHTTPInfo = (BrowserHTTPInfo)o;
        return Objects.equals((Object)this.requestType, (Object)browserHTTPInfo.requestType) && Objects.equals(this.url, browserHTTPInfo.url) && Objects.equals(this.form, browserHTTPInfo.form);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestType, this.url, this.form});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrowserHTTPInfo {\n");
        sb.append("    requestType: ").append(this.toIndentedString((Object)this.requestType)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    form: ").append(this.toIndentedString(this.form)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RequestTypeEnum {
        GET("get"),
        POST("post");

        private String value;

        private RequestTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestTypeEnum fromValue(String value) {
            for (RequestTypeEnum b : RequestTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

