/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.api;

import dev.vality.swag_webhook_events.api.WebhookApiDelegate;
import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.GeneralError;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="webhook", description="the webhook API")
public interface WebhookApi {
    default public WebhookApiDelegate getDelegate() {
        return new WebhookApiDelegate(){};
    }

    @Operation(operationId="notifyWebhookEvent", summary="Notify of an event", tags={"Event Notifications"}, responses={@ApiResponse(responseCode="200", description="Notification processed"), @ApiResponse(responseCode="404", description="Target resource not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=GeneralError.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/webhook"}, produces={"application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<Void> notifyWebhookEvent(@Parameter(name="Content-Signature", description="Message signature formed according to the above rules ", required=true, schema=@Schema(description="")) @RequestHeader(value="Content-Signature", required=true) String contentSignature, @Parameter(name="Event", description="Data from an event that occurred in the platform", required=true, schema=@Schema(description="")) @Valid @RequestBody Event event) {
        return this.getDelegate().notifyWebhookEvent(contentSignature, event);
    }
}

