package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Payment Terminal Receipt
 */

@Schema(name = "PaymentTerminalReceiptInfo", description = "Payment Terminal Receipt")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-04T08:58:40.515737231Z[Etc/UTC]")
public class PaymentTerminalReceiptInfo   {

  @JsonProperty("shortPaymentId")
  private String shortPaymentId;

  @JsonProperty("due")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime due;

  public PaymentTerminalReceiptInfo shortPaymentId(String shortPaymentId) {
    this.shortPaymentId = shortPaymentId;
    return this;
  }

  /**
   * Short payment id
   * @return shortPaymentId
  */
  @NotNull 
  @Schema(name = "shortPaymentId", description = "Short payment id", required = true)
  public String getShortPaymentId() {
    return shortPaymentId;
  }

  public void setShortPaymentId(String shortPaymentId) {
    this.shortPaymentId = shortPaymentId;
  }

  public PaymentTerminalReceiptInfo due(OffsetDateTime due) {
    this.due = due;
    return this;
  }

  /**
   * Payment closing date and time
   * @return due
  */
  @NotNull @Valid 
  @Schema(name = "due", description = "Payment closing date and time", required = true)
  public OffsetDateTime getDue() {
    return due;
  }

  public void setDue(OffsetDateTime due) {
    this.due = due;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentTerminalReceiptInfo paymentTerminalReceiptInfo = (PaymentTerminalReceiptInfo) o;
    return Objects.equals(this.shortPaymentId, paymentTerminalReceiptInfo.shortPaymentId) &&
        Objects.equals(this.due, paymentTerminalReceiptInfo.due);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shortPaymentId, due);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentTerminalReceiptInfo {\n");
    sb.append("    shortPaymentId: ").append(toIndentedString(shortPaymentId)).append("\n");
    sb.append("    due: ").append(toIndentedString(due)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

