package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.Invoice;
import dev.vality.swag_webhook_events.model.Payment;
import dev.vality.swag_webhook_events.model.PaymentStartedAllOf;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Invoice payment start event
 */

@Schema(name = "PaymentStarted", description = "Invoice payment start event")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-04T08:58:40.515737231Z[Etc/UTC]")
public class PaymentStarted extends Event  {

  @JsonProperty("invoice")
  private Invoice invoice;

  @JsonProperty("payment")
  private Payment payment;

  public PaymentStarted invoice(Invoice invoice) {
    this.invoice = invoice;
    return this;
  }

  /**
   * Get invoice
   * @return invoice
  */
  @NotNull @Valid 
  @Schema(name = "invoice", required = true)
  public Invoice getInvoice() {
    return invoice;
  }

  public void setInvoice(Invoice invoice) {
    this.invoice = invoice;
  }

  public PaymentStarted payment(Payment payment) {
    this.payment = payment;
    return this;
  }

  /**
   * Get payment
   * @return payment
  */
  @NotNull @Valid 
  @Schema(name = "payment", required = true)
  public Payment getPayment() {
    return payment;
  }

  public void setPayment(Payment payment) {
    this.payment = payment;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentStarted paymentStarted = (PaymentStarted) o;
    return Objects.equals(this.invoice, paymentStarted.invoice) &&
        Objects.equals(this.payment, paymentStarted.payment) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoice, payment, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentStarted {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoice: ").append(toIndentedString(invoice)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

