package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.UserInteractionDetails;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Event about request user interaction
 */

@Schema(name = "PaymentInteractionRequested", description = "Event about request user interaction")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-04T08:58:40.515737231Z[Etc/UTC]")
public class PaymentInteractionRequested extends Event  {

  @JsonProperty("userInteractionDetails")
  private UserInteractionDetails userInteractionDetails;

  @JsonProperty("invoiceId")
  private String invoiceId;

  @JsonProperty("paymentId")
  private String paymentId;

  public PaymentInteractionRequested userInteractionDetails(UserInteractionDetails userInteractionDetails) {
    this.userInteractionDetails = userInteractionDetails;
    return this;
  }

  /**
   * Get userInteractionDetails
   * @return userInteractionDetails
  */
  @NotNull @Valid 
  @Schema(name = "userInteractionDetails", required = true)
  public UserInteractionDetails getUserInteractionDetails() {
    return userInteractionDetails;
  }

  public void setUserInteractionDetails(UserInteractionDetails userInteractionDetails) {
    this.userInteractionDetails = userInteractionDetails;
  }

  public PaymentInteractionRequested invoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

  /**
   * Invoice ID
   * @return invoiceId
  */
  @NotNull 
  @Schema(name = "invoiceId", description = "Invoice ID", required = true)
  public String getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
  }

  public PaymentInteractionRequested paymentId(String paymentId) {
    this.paymentId = paymentId;
    return this;
  }

  /**
   * Payment ID
   * @return paymentId
  */
  @NotNull 
  @Schema(name = "paymentId", description = "Payment ID", required = true)
  public String getPaymentId() {
    return paymentId;
  }

  public void setPaymentId(String paymentId) {
    this.paymentId = paymentId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentInteractionRequested paymentInteractionRequested = (PaymentInteractionRequested) o;
    return Objects.equals(this.userInteractionDetails, paymentInteractionRequested.userInteractionDetails) &&
        Objects.equals(this.invoiceId, paymentInteractionRequested.invoiceId) &&
        Objects.equals(this.paymentId, paymentInteractionRequested.paymentId) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userInteractionDetails, invoiceId, paymentId, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentInteractionRequested {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    userInteractionDetails: ").append(toIndentedString(userInteractionDetails)).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    paymentId: ").append(toIndentedString(paymentId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

