package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Payer;
import dev.vality.swag_webhook_events.model.PaymentContactInfo;
import dev.vality.swag_webhook_events.model.PaymentError;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Invoice payment data
 */

@Schema(name = "Payment", description = "Invoice payment data")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-04T08:58:40.515737231Z[Etc/UTC]")
public class Payment   {

  @JsonProperty("id")
  private String id;

  @JsonProperty("createdAt")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  /**
   * Payment status
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    PROCESSED("processed"),
    
    CAPTURED("captured"),
    
    CANCELLED("cancelled"),
    
    REFUNDED("refunded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("error")
  private PaymentError error;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("changedAmount")
  private Long changedAmount;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("metadata")
  private Object metadata;

  @JsonProperty("paymentToolToken")
  private String paymentToolToken;

  @JsonProperty("paymentSession")
  private String paymentSession;

  @JsonProperty("contactInfo")
  private PaymentContactInfo contactInfo;

  @JsonProperty("ip")
  private String ip;

  @JsonProperty("fingerprint")
  private String fingerprint;

  @JsonProperty("payer")
  private Payer payer;

  @JsonProperty("fee")
  private Long fee;

  @JsonProperty("rrn")
  private String rrn;

  @JsonProperty("externalId")
  private String externalId;

  @JsonProperty("extraPaymentInfo")
  private Object extraPaymentInfo;

  public Payment id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Payment ID
   * @return id
  */
  @NotNull 
  @Schema(name = "id", description = "Payment ID", required = true)
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Payment createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Date and time of creation
   * @return createdAt
  */
  @NotNull @Valid 
  @Schema(name = "createdAt", description = "Date and time of creation", required = true)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Payment status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Payment status
   * @return status
  */
  @NotNull 
  @Schema(name = "status", description = "Payment status", required = true)
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Payment error(PaymentError error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  */
  @Valid 
  @Schema(name = "error", required = false)
  public PaymentError getError() {
    return error;
  }

  public void setError(PaymentError error) {
    this.error = error;
  }

  public Payment amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The price of the goods or services offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency 
   * minimum: 1
   * @return amount
  */
  @NotNull @Min(1L) 
  @Schema(name = "amount", description = "The price of the goods or services offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ", required = true)
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public Payment changedAmount(Long changedAmount) {
    this.changedAmount = changedAmount;
    return this;
  }

  /**
   * Changed payment amount on the provider side 
   * minimum: 1
   * @return changedAmount
  */
  @Min(1L) 
  @Schema(name = "changedAmount", description = "Changed payment amount on the provider side ", required = false)
  public Long getChangedAmount() {
    return changedAmount;
  }

  public void setChangedAmount(Long changedAmount) {
    this.changedAmount = changedAmount;
  }

  public Payment currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  */
  @NotNull 
  @Schema(name = "currency", description = "Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ", required = true)
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Payment metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Payment metadata
   * @return metadata
  */
  
  @Schema(name = "metadata", description = "Payment metadata", required = false)
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public Payment paymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
    return this;
  }

  /**
   * **Deprecated.** _Use the `payer` property._  Payment tool token 
   * @return paymentToolToken
  */
  
  @Schema(name = "paymentToolToken", description = "**Deprecated.** _Use the `payer` property._  Payment tool token ", required = false)
  public String getPaymentToolToken() {
    return paymentToolToken;
  }

  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }

  public Payment paymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
    return this;
  }

  /**
   * **Deprecated.** _Use the `payer` property._  Payment session identifier 
   * @return paymentSession
  */
  @NotNull 
  @Schema(name = "paymentSession", description = "**Deprecated.** _Use the `payer` property._  Payment session identifier ", required = true)
  public String getPaymentSession() {
    return paymentSession;
  }

  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }

  public Payment contactInfo(PaymentContactInfo contactInfo) {
    this.contactInfo = contactInfo;
    return this;
  }

  /**
   * Get contactInfo
   * @return contactInfo
  */
  @NotNull @Valid 
  @Schema(name = "contactInfo", required = true)
  public PaymentContactInfo getContactInfo() {
    return contactInfo;
  }

  public void setContactInfo(PaymentContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }

  public Payment ip(String ip) {
    this.ip = ip;
    return this;
  }

  /**
   * **Deprecated.** _Use the `payer` property._  Payer's IP-address 
   * @return ip
  */
  
  @Schema(name = "ip", description = "**Deprecated.** _Use the `payer` property._  Payer's IP-address ", required = false)
  public String getIp() {
    return ip;
  }

  public void setIp(String ip) {
    this.ip = ip;
  }

  public Payment fingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * **Deprecated.** _Use the `payer` property._  Payer's fingerprint 
   * @return fingerprint
  */
  
  @Schema(name = "fingerprint", description = "**Deprecated.** _Use the `payer` property._  Payer's fingerprint ", required = false)
  public String getFingerprint() {
    return fingerprint;
  }

  public void setFingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
  }

  public Payment payer(Payer payer) {
    this.payer = payer;
    return this;
  }

  /**
   * Get payer
   * @return payer
  */
  @NotNull @Valid 
  @Schema(name = "payer", required = true)
  public Payer getPayer() {
    return payer;
  }

  public void setPayer(Payer payer) {
    this.payer = payer;
  }

  public Payment fee(Long fee) {
    this.fee = fee;
    return this;
  }

  /**
   * System fee in minor monetary units. 
   * @return fee
  */
  
  @Schema(name = "fee", description = "System fee in minor monetary units. ", required = false)
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public Payment rrn(String rrn) {
    this.rrn = rrn;
    return this;
  }

  /**
   * Retrieval reference number 
   * @return rrn
  */
  
  @Schema(name = "rrn", description = "Retrieval reference number ", required = false)
  public String getRrn() {
    return rrn;
  }

  public void setRrn(String rrn) {
    this.rrn = rrn;
  }

  public Payment externalId(String externalId) {
    this.externalId = externalId;
    return this;
  }

  /**
   * Merchant's transaction identifier
   * @return externalId
  */
  
  @Schema(name = "externalId", description = "Merchant's transaction identifier", required = false)
  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public Payment extraPaymentInfo(Object extraPaymentInfo) {
    this.extraPaymentInfo = extraPaymentInfo;
    return this;
  }

  /**
   * Additional details about the payment, e.g. masked payer's card number. 
   * @return extraPaymentInfo
  */
  
  @Schema(name = "extraPaymentInfo", description = "Additional details about the payment, e.g. masked payer's card number. ", required = false)
  public Object getExtraPaymentInfo() {
    return extraPaymentInfo;
  }

  public void setExtraPaymentInfo(Object extraPaymentInfo) {
    this.extraPaymentInfo = extraPaymentInfo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payment payment = (Payment) o;
    return Objects.equals(this.id, payment.id) &&
        Objects.equals(this.createdAt, payment.createdAt) &&
        Objects.equals(this.status, payment.status) &&
        Objects.equals(this.error, payment.error) &&
        Objects.equals(this.amount, payment.amount) &&
        Objects.equals(this.changedAmount, payment.changedAmount) &&
        Objects.equals(this.currency, payment.currency) &&
        Objects.equals(this.metadata, payment.metadata) &&
        Objects.equals(this.paymentToolToken, payment.paymentToolToken) &&
        Objects.equals(this.paymentSession, payment.paymentSession) &&
        Objects.equals(this.contactInfo, payment.contactInfo) &&
        Objects.equals(this.ip, payment.ip) &&
        Objects.equals(this.fingerprint, payment.fingerprint) &&
        Objects.equals(this.payer, payment.payer) &&
        Objects.equals(this.fee, payment.fee) &&
        Objects.equals(this.rrn, payment.rrn) &&
        Objects.equals(this.externalId, payment.externalId) &&
        Objects.equals(this.extraPaymentInfo, payment.extraPaymentInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, status, error, amount, changedAmount, currency, metadata, paymentToolToken, paymentSession, contactInfo, ip, fingerprint, payer, fee, rrn, externalId, extraPaymentInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payment {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    changedAmount: ").append(toIndentedString(changedAmount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
    sb.append("    payer: ").append(toIndentedString(payer)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    rrn: ").append(toIndentedString(rrn)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    extraPaymentInfo: ").append(toIndentedString(extraPaymentInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

