package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Payer
 */

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "payerType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = CustomerPayer.class, name = "CustomerPayer"),
  @JsonSubTypes.Type(value = PaymentResourcePayer.class, name = "PaymentResourcePayer"),
  @JsonSubTypes.Type(value = RecurrentPayer.class, name = "RecurrentPayer"),
})
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-04T08:58:40.515737231Z[Etc/UTC]")
public class Payer   {

  /**
   * Payment tool type
   */
  public enum PayerTypeEnum {
    CUSTOMERPAYER("CustomerPayer"),
    
    PAYMENTRESOURCEPAYER("PaymentResourcePayer"),
    
    RECURRENTPAYER("RecurrentPayer");

    private String value;

    PayerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayerTypeEnum fromValue(String value) {
      for (PayerTypeEnum b : PayerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("payerType")
  private PayerTypeEnum payerType;

  public Payer payerType(PayerTypeEnum payerType) {
    this.payerType = payerType;
    return this;
  }

  /**
   * Payment tool type
   * @return payerType
  */
  @NotNull 
  @Schema(name = "payerType", description = "Payment tool type", required = true)
  public PayerTypeEnum getPayerType() {
    return payerType;
  }

  public void setPayerType(PayerTypeEnum payerType) {
    this.payerType = payerType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payer payer = (Payer) o;
    return Objects.equals(this.payerType, payer.payerType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payerType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payer {\n");
    sb.append("    payerType: ").append(toIndentedString(payerType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

