package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag_webhook_events.model.InvoiceCartLineTaxMode;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Product or service item
 */

@Schema(name = "InvoiceCartLine", description = "Product or service item")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-04T08:58:40.515737231Z[Etc/UTC]")
public class InvoiceCartLine   {

  @JsonProperty("product")
  private String product;

  @JsonProperty("quantity")
  private Long quantity = 1l;

  @JsonProperty("price")
  private Long price;

  @JsonProperty("cost")
  private Long cost;

  @JsonProperty("taxMode")
  private InvoiceCartLineTaxMode taxMode;

  public InvoiceCartLine product(String product) {
    this.product = product;
    return this;
  }

  /**
   * Description of the goods or services offered
   * @return product
  */
  @NotNull @Size(max = 1000) 
  @Schema(name = "product", description = "Description of the goods or services offered", required = true)
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public InvoiceCartLine quantity(Long quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * Number of units of goods or services offered in this item 
   * minimum: 1
   * @return quantity
  */
  @NotNull @Min(1L) 
  @Schema(name = "quantity", description = "Number of units of goods or services offered in this item ", required = true)
  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public InvoiceCartLine price(Long price) {
    this.price = price;
    return this;
  }

  /**
   * The price of the good or service offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency 
   * minimum: 1
   * @return price
  */
  @NotNull @Min(1L) 
  @Schema(name = "price", description = "The price of the good or service offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ", required = true)
  public Long getPrice() {
    return price;
  }

  public void setPrice(Long price) {
    this.price = price;
  }

  public InvoiceCartLine cost(Long cost) {
    this.cost = cost;
    return this;
  }

  /**
   * The total value of the item, taking into account the number of units of goods or services 
   * minimum: 1
   * @return cost
  */
  @NotNull @Min(1L) 
  @Schema(name = "cost", description = "The total value of the item, taking into account the number of units of goods or services ", required = true)
  public Long getCost() {
    return cost;
  }

  public void setCost(Long cost) {
    this.cost = cost;
  }

  public InvoiceCartLine taxMode(InvoiceCartLineTaxMode taxMode) {
    this.taxMode = taxMode;
    return this;
  }

  /**
   * Get taxMode
   * @return taxMode
  */
  @Valid 
  @Schema(name = "taxMode", required = false)
  public InvoiceCartLineTaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(InvoiceCartLineTaxMode taxMode) {
    this.taxMode = taxMode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceCartLine invoiceCartLine = (InvoiceCartLine) o;
    return Objects.equals(this.product, invoiceCartLine.product) &&
        Objects.equals(this.quantity, invoiceCartLine.quantity) &&
        Objects.equals(this.price, invoiceCartLine.price) &&
        Objects.equals(this.cost, invoiceCartLine.cost) &&
        Objects.equals(this.taxMode, invoiceCartLine.taxMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, quantity, price, cost, taxMode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceCartLine {\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    cost: ").append(toIndentedString(cost)).append("\n");
    sb.append("    taxMode: ").append(toIndentedString(taxMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

