package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag_webhook_events.model.Rational;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Crypto currency transfer request
 */

@Schema(name = "CryptoCurrencyTransferInfo", description = "Crypto currency transfer request")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-04-04T08:58:40.515737231Z[Etc/UTC]")
public class CryptoCurrencyTransferInfo   {

  @JsonProperty("cryptoAddress")
  private String cryptoAddress;

  @JsonProperty("cryptoAmount")
  private Rational cryptoAmount;

  @JsonProperty("cryptoCurrency")
  private String cryptoCurrency;

  public CryptoCurrencyTransferInfo cryptoAddress(String cryptoAddress) {
    this.cryptoAddress = cryptoAddress;
    return this;
  }

  /**
   * Crypto address
   * @return cryptoAddress
  */
  @NotNull 
  @Schema(name = "cryptoAddress", description = "Crypto address", required = true)
  public String getCryptoAddress() {
    return cryptoAddress;
  }

  public void setCryptoAddress(String cryptoAddress) {
    this.cryptoAddress = cryptoAddress;
  }

  public CryptoCurrencyTransferInfo cryptoAmount(Rational cryptoAmount) {
    this.cryptoAmount = cryptoAmount;
    return this;
  }

  /**
   * Get cryptoAmount
   * @return cryptoAmount
  */
  @NotNull @Valid 
  @Schema(name = "cryptoAmount", required = true)
  public Rational getCryptoAmount() {
    return cryptoAmount;
  }

  public void setCryptoAmount(Rational cryptoAmount) {
    this.cryptoAmount = cryptoAmount;
  }

  public CryptoCurrencyTransferInfo cryptoCurrency(String cryptoCurrency) {
    this.cryptoCurrency = cryptoCurrency;
    return this;
  }

  /**
   * Cryptocurrency type
   * @return cryptoCurrency
  */
  @NotNull 
  @Schema(name = "cryptoCurrency", description = "Cryptocurrency type", required = true)
  public String getCryptoCurrency() {
    return cryptoCurrency;
  }

  public void setCryptoCurrency(String cryptoCurrency) {
    this.cryptoCurrency = cryptoCurrency;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoCurrencyTransferInfo cryptoCurrencyTransferInfo = (CryptoCurrencyTransferInfo) o;
    return Objects.equals(this.cryptoAddress, cryptoCurrencyTransferInfo.cryptoAddress) &&
        Objects.equals(this.cryptoAmount, cryptoCurrencyTransferInfo.cryptoAmount) &&
        Objects.equals(this.cryptoCurrency, cryptoCurrencyTransferInfo.cryptoCurrency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cryptoAddress, cryptoAmount, cryptoCurrency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoCurrencyTransferInfo {\n");
    sb.append("    cryptoAddress: ").append(toIndentedString(cryptoAddress)).append("\n");
    sb.append("    cryptoAmount: ").append(toIndentedString(cryptoAmount)).append("\n");
    sb.append("    cryptoCurrency: ").append(toIndentedString(cryptoCurrency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

