package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * UserInteractionDetails
 */

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "userInteractionType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = ApiExtensionRequest.class, name = "ApiExtensionRequest"),
  @JsonSubTypes.Type(value = BrowserHTTPRequest.class, name = "BrowserHTTPRequest"),
  @JsonSubTypes.Type(value = CryptoCurrencyTransferRequest.class, name = "CryptoCurrencyTransferRequest"),
  @JsonSubTypes.Type(value = PaymentTerminalReceipt.class, name = "PaymentTerminalReceipt"),
  @JsonSubTypes.Type(value = QrCodeDisplayRequest.class, name = "QrCodeDisplayRequest"),
})
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-02-26T07:25:16.040246332Z[Etc/UTC]")
public class UserInteractionDetails   {

  /**
   * Type of user interactions
   */
  public enum UserInteractionTypeEnum {
    BROWSERHTTPREQUEST("BrowserHTTPRequest"),
    
    PAYMENTTERMINALRECEIPT("PaymentTerminalReceipt"),
    
    CRYPTOCURRENCYTRANSFERREQUEST("CryptoCurrencyTransferRequest"),
    
    QRCODEDISPLAYREQUEST("QrCodeDisplayRequest"),
    
    APIEXTENSIONREQUEST("ApiExtensionRequest");

    private String value;

    UserInteractionTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static UserInteractionTypeEnum fromValue(String value) {
      for (UserInteractionTypeEnum b : UserInteractionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("userInteractionType")
  private UserInteractionTypeEnum userInteractionType;

  public UserInteractionDetails userInteractionType(UserInteractionTypeEnum userInteractionType) {
    this.userInteractionType = userInteractionType;
    return this;
  }

  /**
   * Type of user interactions
   * @return userInteractionType
  */
  @NotNull 
  @Schema(name = "userInteractionType", description = "Type of user interactions", required = true)
  public UserInteractionTypeEnum getUserInteractionType() {
    return userInteractionType;
  }

  public void setUserInteractionType(UserInteractionTypeEnum userInteractionType) {
    this.userInteractionType = userInteractionType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserInteractionDetails userInteractionDetails = (UserInteractionDetails) o;
    return Objects.equals(this.userInteractionType, userInteractionDetails.userInteractionType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userInteractionType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserInteractionDetails {\n");
    sb.append("    userInteractionType: ").append(toIndentedString(userInteractionType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

