package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Parent payment, on the basis of which the current recurrent payment was created 
 */

@Schema(name = "PaymentRecurrentParent", description = "Parent payment, on the basis of which the current recurrent payment was created ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-02-26T07:25:16.040246332Z[Etc/UTC]")
public class PaymentRecurrentParent   {

  @JsonProperty("invoiceID")
  private String invoiceID;

  @JsonProperty("paymentID")
  private String paymentID;

  public PaymentRecurrentParent invoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
    return this;
  }

  /**
   * Invoice ID
   * @return invoiceID
  */
  @NotNull 
  @Schema(name = "invoiceID", description = "Invoice ID", required = true)
  public String getInvoiceID() {
    return invoiceID;
  }

  public void setInvoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
  }

  public PaymentRecurrentParent paymentID(String paymentID) {
    this.paymentID = paymentID;
    return this;
  }

  /**
   * Payment ID
   * @return paymentID
  */
  @NotNull 
  @Schema(name = "paymentID", description = "Payment ID", required = true)
  public String getPaymentID() {
    return paymentID;
  }

  public void setPaymentID(String paymentID) {
    this.paymentID = paymentID;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentRecurrentParent paymentRecurrentParent = (PaymentRecurrentParent) o;
    return Objects.equals(this.invoiceID, paymentRecurrentParent.invoiceID) &&
        Objects.equals(this.paymentID, paymentRecurrentParent.paymentID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceID, paymentID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentRecurrentParent {\n");
    sb.append("    invoiceID: ").append(toIndentedString(invoiceID)).append("\n");
    sb.append("    paymentID: ").append(toIndentedString(paymentID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

