package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Crypto currency transfer request
 */

@Schema(name = "CryptoCurrencyTransferInfo", description = "Crypto currency transfer request")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-02-26T07:25:16.040246332Z[Etc/UTC]")
public class CryptoCurrencyTransferInfo   {

  @JsonProperty("cryptoAddress")
  private String cryptoAddress;

  @JsonProperty("cryptoCash")
  private String cryptoCash;

  public CryptoCurrencyTransferInfo cryptoAddress(String cryptoAddress) {
    this.cryptoAddress = cryptoAddress;
    return this;
  }

  /**
   * Crypto address
   * @return cryptoAddress
  */
  @NotNull 
  @Schema(name = "cryptoAddress", description = "Crypto address", required = true)
  public String getCryptoAddress() {
    return cryptoAddress;
  }

  public void setCryptoAddress(String cryptoAddress) {
    this.cryptoAddress = cryptoAddress;
  }

  public CryptoCurrencyTransferInfo cryptoCash(String cryptoCash) {
    this.cryptoCash = cryptoCash;
    return this;
  }

  /**
   * Cryptocurrency type
   * @return cryptoCash
  */
  @NotNull 
  @Schema(name = "cryptoCash", description = "Cryptocurrency type", required = true)
  public String getCryptoCash() {
    return cryptoCash;
  }

  public void setCryptoCash(String cryptoCash) {
    this.cryptoCash = cryptoCash;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoCurrencyTransferInfo cryptoCurrencyTransferInfo = (CryptoCurrencyTransferInfo) o;
    return Objects.equals(this.cryptoAddress, cryptoCurrencyTransferInfo.cryptoAddress) &&
        Objects.equals(this.cryptoCash, cryptoCurrencyTransferInfo.cryptoCash);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cryptoAddress, cryptoCash);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoCurrencyTransferInfo {\n");
    sb.append("    cryptoAddress: ").append(toIndentedString(cryptoAddress)).append("\n");
    sb.append("    cryptoCash: ").append(toIndentedString(cryptoCash)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

