package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Payment tool details
 */

@Schema(name = "PaymentToolDetails", description = "Payment tool details")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "detailsType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = PaymentToolDetailsBankCard.class, name = "PaymentToolDetailsBankCard"),
  @JsonSubTypes.Type(value = PaymentToolDetailsCryptoWallet.class, name = "PaymentToolDetailsCryptoWallet"),
  @JsonSubTypes.Type(value = PaymentToolDetailsDigitalWallet.class, name = "PaymentToolDetailsDigitalWallet"),
  @JsonSubTypes.Type(value = PaymentToolDetailsMobileCommerce.class, name = "PaymentToolDetailsMobileCommerce"),
  @JsonSubTypes.Type(value = PaymentToolDetailsPaymentTerminal.class, name = "PaymentToolDetailsPaymentTerminal"),
})
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-02-26T07:25:16.040246332Z[Etc/UTC]")
public class PaymentToolDetails   {

  /**
   * Type of payment tool
   */
  public enum DetailsTypeEnum {
    PAYMENTTOOLDETAILSBANKCARD("PaymentToolDetailsBankCard"),
    
    PAYMENTTOOLDETAILSPAYMENTTERMINAL("PaymentToolDetailsPaymentTerminal"),
    
    PAYMENTTOOLDETAILSDIGITALWALLET("PaymentToolDetailsDigitalWallet"),
    
    PAYMENTTOOLDETAILSCRYPTOWALLET("PaymentToolDetailsCryptoWallet"),
    
    PAYMENTTOOLDETAILSMOBILECOMMERCE("PaymentToolDetailsMobileCommerce");

    private String value;

    DetailsTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DetailsTypeEnum fromValue(String value) {
      for (DetailsTypeEnum b : DetailsTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("detailsType")
  private DetailsTypeEnum detailsType;

  public PaymentToolDetails detailsType(DetailsTypeEnum detailsType) {
    this.detailsType = detailsType;
    return this;
  }

  /**
   * Type of payment tool
   * @return detailsType
  */
  @NotNull 
  @Schema(name = "detailsType", description = "Type of payment tool", required = true)
  public DetailsTypeEnum getDetailsType() {
    return detailsType;
  }

  public void setDetailsType(DetailsTypeEnum detailsType) {
    this.detailsType = detailsType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetails paymentToolDetails = (PaymentToolDetails) o;
    return Objects.equals(this.detailsType, paymentToolDetails.detailsType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(detailsType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetails {\n");
    sb.append("    detailsType: ").append(toIndentedString(detailsType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

