package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag_webhook_events.model.ClientInfo;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Payment tool details
 */

@Schema(name = "PaymentResource", description = "Payment tool details")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-02-26T07:25:16.040246332Z[Etc/UTC]")
public class PaymentResource   {

  @JsonProperty("paymentToolToken")
  private String paymentToolToken;

  @JsonProperty("paymentSession")
  private String paymentSession;

  @JsonProperty("paymentToolDetails")
  private PaymentToolDetails paymentToolDetails;

  @JsonProperty("clientInfo")
  private ClientInfo clientInfo;

  public PaymentResource paymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
    return this;
  }

  /**
   * Payment tool token provided by the payer
   * @return paymentToolToken
  */
  @NotNull @Size(max = 1000) 
  @Schema(name = "paymentToolToken", description = "Payment tool token provided by the payer", required = true)
  public String getPaymentToolToken() {
    return paymentToolToken;
  }

  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }

  public PaymentResource paymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
    return this;
  }

  /**
   * Payment session identifier
   * @return paymentSession
  */
  @NotNull @Size(max = 1000) 
  @Schema(name = "paymentSession", description = "Payment session identifier", required = true)
  public String getPaymentSession() {
    return paymentSession;
  }

  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }

  public PaymentResource paymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
    return this;
  }

  /**
   * Get paymentToolDetails
   * @return paymentToolDetails
  */
  @Valid 
  @Schema(name = "paymentToolDetails", required = false)
  public PaymentToolDetails getPaymentToolDetails() {
    return paymentToolDetails;
  }

  public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
  }

  public PaymentResource clientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
    return this;
  }

  /**
   * Get clientInfo
   * @return clientInfo
  */
  @Valid 
  @Schema(name = "clientInfo", required = false)
  public ClientInfo getClientInfo() {
    return clientInfo;
  }

  public void setClientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentResource paymentResource = (PaymentResource) o;
    return Objects.equals(this.paymentToolToken, paymentResource.paymentToolToken) &&
        Objects.equals(this.paymentSession, paymentResource.paymentSession) &&
        Objects.equals(this.paymentToolDetails, paymentResource.paymentToolDetails) &&
        Objects.equals(this.clientInfo, paymentResource.clientInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentToolToken, paymentSession, paymentToolDetails, clientInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentResource {\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    paymentToolDetails: ").append(toIndentedString(paymentToolDetails)).append("\n");
    sb.append("    clientInfo: ").append(toIndentedString(clientInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

