package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.Invoice;
import dev.vality.swag_webhook_events.model.InvoiceCreatedAllOf;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Invoice cancellation event with reason, e.g. expiration of the invoice due date 
 */

@Schema(name = "InvoiceCancelled", description = "Invoice cancellation event with reason, e.g. expiration of the invoice due date ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-02-26T07:25:16.040246332Z[Etc/UTC]")
public class InvoiceCancelled extends Event  {

  @JsonProperty("invoice")
  private Invoice invoice;

  public InvoiceCancelled invoice(Invoice invoice) {
    this.invoice = invoice;
    return this;
  }

  /**
   * Get invoice
   * @return invoice
  */
  @NotNull @Valid 
  @Schema(name = "invoice", required = true)
  public Invoice getInvoice() {
    return invoice;
  }

  public void setInvoice(Invoice invoice) {
    this.invoice = invoice;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceCancelled invoiceCancelled = (InvoiceCancelled) o;
    return Objects.equals(this.invoice, invoiceCancelled.invoice) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoice, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceCancelled {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoice: ").append(toIndentedString(invoice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

