package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.InvoiceCartLine;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Invoice data
 */

@Schema(name = "Invoice", description = "Invoice data")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-02-26T07:25:16.040246332Z[Etc/UTC]")
public class Invoice   {

  @JsonProperty("id")
  private String id;

  @JsonProperty("shopID")
  private String shopID;

  @JsonProperty("createdAt")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  /**
   * Invoice status
   */
  public enum StatusEnum {
    UNPAID("unpaid"),
    
    CANCELLED("cancelled"),
    
    PAID("paid"),
    
    REFUNDED("refunded"),
    
    FULFILLED("fulfilled");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("reason")
  private String reason;

  @JsonProperty("dueDate")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime dueDate;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("metadata")
  private Object metadata;

  @JsonProperty("product")
  private String product;

  @JsonProperty("description")
  private String description;

  @JsonProperty("cart")
  @Valid
  private List<InvoiceCartLine> cart = null;

  @JsonProperty("externalId")
  private String externalId;

  public Invoice id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Invoice ID
   * @return id
  */
  @NotNull 
  @Schema(name = "id", description = "Invoice ID", required = true)
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Invoice shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Shop ID
   * @return shopID
  */
  @NotNull 
  @Schema(name = "shopID", description = "Shop ID", required = true)
  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public Invoice createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Date and time of creation
   * @return createdAt
  */
  @NotNull @Valid 
  @Schema(name = "createdAt", description = "Date and time of creation", required = true)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Invoice status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Invoice status
   * @return status
  */
  @NotNull 
  @Schema(name = "status", description = "Invoice status", required = true)
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Invoice reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * Reason for invoice cancellation or redemption
   * @return reason
  */
  
  @Schema(name = "reason", description = "Reason for invoice cancellation or redemption", required = false)
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public Invoice dueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
    return this;
  }

  /**
   * Expiration date and time
   * @return dueDate
  */
  @NotNull @Valid 
  @Schema(name = "dueDate", description = "Expiration date and time", required = true)
  public OffsetDateTime getDueDate() {
    return dueDate;
  }

  public void setDueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
  }

  public Invoice amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The price of the goods or services offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency 
   * minimum: 1
   * @return amount
  */
  @NotNull @Min(1L) 
  @Schema(name = "amount", description = "The price of the goods or services offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ", required = true)
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public Invoice currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  */
  @NotNull 
  @Schema(name = "currency", description = "Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ", required = true)
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Invoice metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Invoice metadata
   * @return metadata
  */
  @NotNull 
  @Schema(name = "metadata", description = "Invoice metadata", required = true)
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public Invoice product(String product) {
    this.product = product;
    return this;
  }

  /**
   * Name of the offered goods or services
   * @return product
  */
  @NotNull 
  @Schema(name = "product", description = "Name of the offered goods or services", required = true)
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public Invoice description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description of the goods or services offered
   * @return description
  */
  
  @Schema(name = "description", description = "Description of the goods or services offered", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Invoice cart(List<InvoiceCartLine> cart) {
    this.cart = cart;
    return this;
  }

  public Invoice addCartItem(InvoiceCartLine cartItem) {
    if (this.cart == null) {
      this.cart = new ArrayList<>();
    }
    this.cart.add(cartItem);
    return this;
  }

  /**
   * A shopping cart with a list of items of provided goods or services 
   * @return cart
  */
  @Valid @Size(min = 1, max = 100) 
  @Schema(name = "cart", description = "A shopping cart with a list of items of provided goods or services ", required = false)
  public List<InvoiceCartLine> getCart() {
    return cart;
  }

  public void setCart(List<InvoiceCartLine> cart) {
    this.cart = cart;
  }

  public Invoice externalId(String externalId) {
    this.externalId = externalId;
    return this;
  }

  /**
   * Merchant's transaction identifier
   * @return externalId
  */
  
  @Schema(name = "externalId", description = "Merchant's transaction identifier", required = false)
  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Invoice invoice = (Invoice) o;
    return Objects.equals(this.id, invoice.id) &&
        Objects.equals(this.shopID, invoice.shopID) &&
        Objects.equals(this.createdAt, invoice.createdAt) &&
        Objects.equals(this.status, invoice.status) &&
        Objects.equals(this.reason, invoice.reason) &&
        Objects.equals(this.dueDate, invoice.dueDate) &&
        Objects.equals(this.amount, invoice.amount) &&
        Objects.equals(this.currency, invoice.currency) &&
        Objects.equals(this.metadata, invoice.metadata) &&
        Objects.equals(this.product, invoice.product) &&
        Objects.equals(this.description, invoice.description) &&
        Objects.equals(this.cart, invoice.cart) &&
        Objects.equals(this.externalId, invoice.externalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, shopID, createdAt, status, reason, dueDate, amount, currency, metadata, product, description, cart, externalId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Invoice {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

