package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Browser http request
 */

@Schema(name = "BrowserHTTPInfo", description = "Browser http request")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-02-26T07:25:16.040246332Z[Etc/UTC]")
public class BrowserHTTPInfo   {

  /**
   * Type of http request
   */
  public enum RequestTypeEnum {
    GET("get"),
    
    POST("post");

    private String value;

    RequestTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestTypeEnum fromValue(String value) {
      for (RequestTypeEnum b : RequestTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("requestType")
  private RequestTypeEnum requestType;

  @JsonProperty("url")
  private String url;

  @JsonProperty("form")
  @Valid
  private Map<String, String> form = null;

  public BrowserHTTPInfo requestType(RequestTypeEnum requestType) {
    this.requestType = requestType;
    return this;
  }

  /**
   * Type of http request
   * @return requestType
  */
  @NotNull 
  @Schema(name = "requestType", description = "Type of http request", required = true)
  public RequestTypeEnum getRequestType() {
    return requestType;
  }

  public void setRequestType(RequestTypeEnum requestType) {
    this.requestType = requestType;
  }

  public BrowserHTTPInfo url(String url) {
    this.url = url;
    return this;
  }

  /**
   * Uniform Resource Locator
   * @return url
  */
  @NotNull @Size(max = 1000) 
  @Schema(name = "url", description = "Uniform Resource Locator", required = true)
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public BrowserHTTPInfo form(Map<String, String> form) {
    this.form = form;
    return this;
  }

  public BrowserHTTPInfo putFormItem(String key, String formItem) {
    if (this.form == null) {
      this.form = new HashMap<>();
    }
    this.form.put(key, formItem);
    return this;
  }

  /**
   * Get form
   * @return form
  */
  
  @Schema(name = "form", required = false)
  public Map<String, String> getForm() {
    return form;
  }

  public void setForm(Map<String, String> form) {
    this.form = form;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BrowserHTTPInfo browserHTTPInfo = (BrowserHTTPInfo) o;
    return Objects.equals(this.requestType, browserHTTPInfo.requestType) &&
        Objects.equals(this.url, browserHTTPInfo.url) &&
        Objects.equals(this.form, browserHTTPInfo.form);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestType, url, form);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BrowserHTTPInfo {\n");
    sb.append("    requestType: ").append(toIndentedString(requestType)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    form: ").append(toIndentedString(form)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

