/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.vality.swag_webhook_events.model.InvoiceCartLineTaxMode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Product or service item")
@JsonPropertyOrder(value={"product", "quantity", "price", "cost", "taxMode"})
@JsonTypeName(value="InvoiceCartLine")
public class InvoiceCartLine {
    public static final String JSON_PROPERTY_PRODUCT = "product";
    private String product;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Long quantity = 1L;
    public static final String JSON_PROPERTY_PRICE = "price";
    private Long price;
    public static final String JSON_PROPERTY_COST = "cost";
    private Long cost;
    public static final String JSON_PROPERTY_TAX_MODE = "taxMode";
    private InvoiceCartLineTaxMode taxMode;

    public InvoiceCartLine product(String product) {
        this.product = product;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Description of the goods or services offered")
    @JsonProperty(value="product")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProduct() {
        return this.product;
    }

    @JsonProperty(value="product")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProduct(String product) {
        this.product = product;
    }

    public InvoiceCartLine quantity(Long quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of units of goods or services offered in this item ")
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public InvoiceCartLine price(Long price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The price of the good or service offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(Long price) {
        this.price = price;
    }

    public InvoiceCartLine cost(Long cost) {
        this.cost = cost;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The total value of the item, taking into account the number of units of goods or services ")
    @JsonProperty(value="cost")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getCost() {
        return this.cost;
    }

    @JsonProperty(value="cost")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCost(Long cost) {
        this.cost = cost;
    }

    public InvoiceCartLine taxMode(InvoiceCartLineTaxMode taxMode) {
        this.taxMode = taxMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="taxMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InvoiceCartLineTaxMode getTaxMode() {
        return this.taxMode;
    }

    @JsonProperty(value="taxMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxMode(InvoiceCartLineTaxMode taxMode) {
        this.taxMode = taxMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceCartLine invoiceCartLine = (InvoiceCartLine)o;
        return Objects.equals(this.product, invoiceCartLine.product) && Objects.equals(this.quantity, invoiceCartLine.quantity) && Objects.equals(this.price, invoiceCartLine.price) && Objects.equals(this.cost, invoiceCartLine.cost) && Objects.equals(this.taxMode, invoiceCartLine.taxMode);
    }

    public int hashCode() {
        return Objects.hash(this.product, this.quantity, this.price, this.cost, this.taxMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceCartLine {\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        sb.append("    taxMode: ").append(this.toIndentedString(this.taxMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

