/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.InvoiceCartLine;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Invoice data")
@JsonPropertyOrder(value={"id", "shopID", "createdAt", "status", "reason", "dueDate", "amount", "currency", "metadata", "product", "description", "cart", "externalId"})
@JsonTypeName(value="Invoice")
public class Invoice {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_SHOP_I_D = "shopID";
    private String shopID;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;
    public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
    private OffsetDateTime dueDate;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Long amount;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Object metadata;
    public static final String JSON_PROPERTY_PRODUCT = "product";
    private String product;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_CART = "cart";
    private List<InvoiceCartLine> cart = null;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;

    public Invoice id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Invoice ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public Invoice shopID(String shopID) {
        this.shopID = shopID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Shop ID")
    @JsonProperty(value="shopID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getShopID() {
        return this.shopID;
    }

    @JsonProperty(value="shopID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setShopID(String shopID) {
        this.shopID = shopID;
    }

    public Invoice createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Date and time of creation")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Invoice status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Invoice status")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Invoice reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for invoice cancellation or redemption")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public Invoice dueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Expiration date and time")
    @JsonProperty(value="dueDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="dueDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public Invoice amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The price of the goods or services offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Invoice currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Invoice metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Invoice metadata")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Object getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Invoice product(String product) {
        this.product = product;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name of the offered goods or services")
    @JsonProperty(value="product")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProduct() {
        return this.product;
    }

    @JsonProperty(value="product")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProduct(String product) {
        this.product = product;
    }

    public Invoice description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the goods or services offered")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Invoice cart(List<InvoiceCartLine> cart) {
        this.cart = cart;
        return this;
    }

    public Invoice addCartItem(InvoiceCartLine cartItem) {
        if (this.cart == null) {
            this.cart = new ArrayList<InvoiceCartLine>();
        }
        this.cart.add(cartItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A shopping cart with a list of items of provided goods or services ")
    @JsonProperty(value="cart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InvoiceCartLine> getCart() {
        return this.cart;
    }

    @JsonProperty(value="cart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCart(List<InvoiceCartLine> cart) {
        this.cart = cart;
    }

    public Invoice externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Merchant's transaction identifier")
    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        return Objects.equals(this.id, invoice.id) && Objects.equals(this.shopID, invoice.shopID) && Objects.equals(this.createdAt, invoice.createdAt) && Objects.equals((Object)this.status, (Object)invoice.status) && Objects.equals(this.reason, invoice.reason) && Objects.equals(this.dueDate, invoice.dueDate) && Objects.equals(this.amount, invoice.amount) && Objects.equals(this.currency, invoice.currency) && Objects.equals(this.metadata, invoice.metadata) && Objects.equals(this.product, invoice.product) && Objects.equals(this.description, invoice.description) && Objects.equals(this.cart, invoice.cart) && Objects.equals(this.externalId, invoice.externalId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.shopID, this.createdAt, this.status, this.reason, this.dueDate, this.amount, this.currency, this.metadata, this.product, this.description, this.cart, this.externalId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invoice {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    shopID: ").append(this.toIndentedString(this.shopID)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    cart: ").append(this.toIndentedString(this.cart)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UNPAID("unpaid"),
        CANCELLED("cancelled"),
        PAID("paid"),
        REFUNDED("refunded"),
        FULFILLED("fulfilled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

