/*
 * Vality Webhooks Events API
 * ## Payment Webhook Events API  The specification defines a protocol for delivering notifications about new payment events within your organisation. The notifications are deliveried by the system as HTTP requests to the URL of webhooks you created. Handlers for such kind of queries should be implemented on the side of your server code according to the specification.  Webhook is a subscription to a specific type of event or group of events relating to different objects within your organisation. API methods described in the specification [Payment Webhook Management API](https://github.com/valitydev/swag-payments) are used to manage webhooks.  When within the wallet one of the events occurs (e.g. a wallet status change), the system selects a webhook matching that event type and sends an HTTP request containing a JSON message to the URL specified in the webhook. If several webhooks matching this event type were created, the event is simultaneously delivered to all URLs specified in those webhooks in an undefined order. ## Delivery strategy The system guarantees events delivery order within a specific notification subject (invoice, payment, refund, etc.). The system maintains a message queue for each notification item to keep the sequence and ensure the guaranteed delivery.  A delivery request is considered to be successful only when a response with status `200` is received. The system will wait for a successful response to the sent a request during 10 seconds. In case of a response with any other status or after expiration of the specified time which was reserved to process the notification, the system will try to re-deliver notifications until a successful response is received, or until a decision is made that it is impossible to deliver information. Delivery attempts will be made at the following time intervals between requests:    - 30 seconds,    - 5 minutes,    - 15 minutes,    - 1 hour.    - every hour within 24 hours  If the last attempt of notification delivery fails, all the events that have been accumulated in this payment queue are discarded. ## Received messages authorization The system confirms notifications authenticity by signing messages with a private key that is unique to each webhook, the paired public key of which is contained in the data of that webhook. The signature is transmitted in the HTTP header Content-Signature. Represented in various atributes the header contains the information about the algorithm used to create a signature and content of the signature in the format [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  At the moment the only one signature generation alorithm is possible to use. ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3) The signature is generated according to [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2) algorithm , which itself uses result of message [SHA-256](https://tools.ietf.org/html/rfc6234) calculation.  The set of header attributes and the list of possible signature generation algorithms can be expanded later. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.RefundError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Refund data within the payment
 */
@ApiModel(description = "Refund data within the payment")
@JsonPropertyOrder({
  Refund.JSON_PROPERTY_ID,
  Refund.JSON_PROPERTY_CREATED_AT,
  Refund.JSON_PROPERTY_STATUS,
  Refund.JSON_PROPERTY_ERROR,
  Refund.JSON_PROPERTY_AMOUNT,
  Refund.JSON_PROPERTY_CURRENCY,
  Refund.JSON_PROPERTY_REASON,
  Refund.JSON_PROPERTY_RRN
})
@JsonTypeName("Refund")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-26T07:25:02.930733331Z[Etc/UTC]")
public class Refund {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  /**
   * Refund status
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    SUCCEEDED("succeeded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_ERROR = "error";
  private RefundError error;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Long amount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_REASON = "reason";
  private String reason;

  public static final String JSON_PROPERTY_RRN = "rrn";
  private String rrn;

  public Refund() { 
  }

  public Refund id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Refund identifier
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Refund identifier")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public Refund createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Date and time of creation
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Date and time of creation")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Refund status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Refund status
   * @return status
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Refund status")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Refund error(RefundError error) {
    
    this.error = error;
    return this;
  }

   /**
   * Get error
   * @return error
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundError getError() {
    return error;
  }


  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setError(RefundError error) {
    this.error = error;
  }


  public Refund amount(Long amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Refund amount in minor monetary units, e.g. cents if U.S. dollars are specified as the currency 
   * minimum: 1
   * @return amount
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Refund amount in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(Long amount) {
    this.amount = amount;
  }


  public Refund currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Refund reason(String reason) {
    
    this.reason = reason;
    return this;
  }

   /**
   * Refund reason
   * @return reason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Refund reason")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReason() {
    return reason;
  }


  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReason(String reason) {
    this.reason = reason;
  }


  public Refund rrn(String rrn) {
    
    this.rrn = rrn;
    return this;
  }

   /**
   * Retrieval reference number 
   * @return rrn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Retrieval reference number ")
  @JsonProperty(JSON_PROPERTY_RRN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRrn() {
    return rrn;
  }


  @JsonProperty(JSON_PROPERTY_RRN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRrn(String rrn) {
    this.rrn = rrn;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Refund refund = (Refund) o;
    return Objects.equals(this.id, refund.id) &&
        Objects.equals(this.createdAt, refund.createdAt) &&
        Objects.equals(this.status, refund.status) &&
        Objects.equals(this.error, refund.error) &&
        Objects.equals(this.amount, refund.amount) &&
        Objects.equals(this.currency, refund.currency) &&
        Objects.equals(this.reason, refund.reason) &&
        Objects.equals(this.rrn, refund.rrn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, status, error, amount, currency, reason, rrn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Refund {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    rrn: ").append(toIndentedString(rrn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

