/*
 * Vality Webhooks Events API
 * ## Payment Webhook Events API  The specification defines a protocol for delivering notifications about new payment events within your organisation. The notifications are deliveried by the system as HTTP requests to the URL of webhooks you created. Handlers for such kind of queries should be implemented on the side of your server code according to the specification.  Webhook is a subscription to a specific type of event or group of events relating to different objects within your organisation. API methods described in the specification [Payment Webhook Management API](https://github.com/valitydev/swag-payments) are used to manage webhooks.  When within the wallet one of the events occurs (e.g. a wallet status change), the system selects a webhook matching that event type and sends an HTTP request containing a JSON message to the URL specified in the webhook. If several webhooks matching this event type were created, the event is simultaneously delivered to all URLs specified in those webhooks in an undefined order. ## Delivery strategy The system guarantees events delivery order within a specific notification subject (invoice, payment, refund, etc.). The system maintains a message queue for each notification item to keep the sequence and ensure the guaranteed delivery.  A delivery request is considered to be successful only when a response with status `200` is received. The system will wait for a successful response to the sent a request during 10 seconds. In case of a response with any other status or after expiration of the specified time which was reserved to process the notification, the system will try to re-deliver notifications until a successful response is received, or until a decision is made that it is impossible to deliver information. Delivery attempts will be made at the following time intervals between requests:    - 30 seconds,    - 5 minutes,    - 15 minutes,    - 1 hour.    - every hour within 24 hours  If the last attempt of notification delivery fails, all the events that have been accumulated in this payment queue are discarded. ## Received messages authorization The system confirms notifications authenticity by signing messages with a private key that is unique to each webhook, the paired public key of which is contained in the data of that webhook. The signature is transmitted in the HTTP header Content-Signature. Represented in various atributes the header contains the information about the algorithm used to create a signature and content of the signature in the format [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  At the moment the only one signature generation alorithm is possible to use. ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3) The signature is generated according to [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2) algorithm , which itself uses result of message [SHA-256](https://tools.ietf.org/html/rfc6234) calculation.  The set of header attributes and the list of possible signature generation algorithms can be expanded later. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.CustomerBindingFailed;
import dev.vality.swag_webhook_events.model.CustomerBindingStarted;
import dev.vality.swag_webhook_events.model.CustomerBindingSucceeded;
import dev.vality.swag_webhook_events.model.CustomerCreated;
import dev.vality.swag_webhook_events.model.CustomerDeleted;
import dev.vality.swag_webhook_events.model.CustomerReady;
import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.Invoice;
import dev.vality.swag_webhook_events.model.InvoiceCancelled;
import dev.vality.swag_webhook_events.model.InvoiceCreated;
import dev.vality.swag_webhook_events.model.InvoiceCreatedAllOf;
import dev.vality.swag_webhook_events.model.InvoiceFulfilled;
import dev.vality.swag_webhook_events.model.InvoicePaid;
import dev.vality.swag_webhook_events.model.PaymentCancelled;
import dev.vality.swag_webhook_events.model.PaymentCaptured;
import dev.vality.swag_webhook_events.model.PaymentCashChanged;
import dev.vality.swag_webhook_events.model.PaymentFailed;
import dev.vality.swag_webhook_events.model.PaymentInteractionCompleted;
import dev.vality.swag_webhook_events.model.PaymentInteractionRequested;
import dev.vality.swag_webhook_events.model.PaymentProcessed;
import dev.vality.swag_webhook_events.model.PaymentRefunded;
import dev.vality.swag_webhook_events.model.PaymentStarted;
import dev.vality.swag_webhook_events.model.RefundCreated;
import dev.vality.swag_webhook_events.model.RefundFailed;
import dev.vality.swag_webhook_events.model.RefundPending;
import dev.vality.swag_webhook_events.model.RefundSucceeded;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The event of full payment of an invoice, which is the reason to start providing goods or services to the payer 
 */
@ApiModel(description = "The event of full payment of an invoice, which is the reason to start providing goods or services to the payer ")
@JsonPropertyOrder({
  InvoicePaid.JSON_PROPERTY_INVOICE
})
@JsonTypeName("InvoicePaid")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-26T07:25:02.930733331Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "eventType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = CustomerBindingFailed.class, name = "CustomerBindingFailed"),
  @JsonSubTypes.Type(value = CustomerBindingStarted.class, name = "CustomerBindingStarted"),
  @JsonSubTypes.Type(value = CustomerBindingSucceeded.class, name = "CustomerBindingSucceeded"),
  @JsonSubTypes.Type(value = CustomerCreated.class, name = "CustomerCreated"),
  @JsonSubTypes.Type(value = CustomerDeleted.class, name = "CustomerDeleted"),
  @JsonSubTypes.Type(value = CustomerReady.class, name = "CustomerReady"),
  @JsonSubTypes.Type(value = InvoiceCancelled.class, name = "InvoiceCancelled"),
  @JsonSubTypes.Type(value = InvoiceCreated.class, name = "InvoiceCreated"),
  @JsonSubTypes.Type(value = InvoiceFulfilled.class, name = "InvoiceFulfilled"),
  @JsonSubTypes.Type(value = InvoicePaid.class, name = "InvoicePaid"),
  @JsonSubTypes.Type(value = PaymentCancelled.class, name = "PaymentCancelled"),
  @JsonSubTypes.Type(value = PaymentCaptured.class, name = "PaymentCaptured"),
  @JsonSubTypes.Type(value = PaymentCashChanged.class, name = "PaymentCashChanged"),
  @JsonSubTypes.Type(value = PaymentFailed.class, name = "PaymentFailed"),
  @JsonSubTypes.Type(value = PaymentInteractionCompleted.class, name = "PaymentInteractionCompleted"),
  @JsonSubTypes.Type(value = PaymentInteractionRequested.class, name = "PaymentInteractionRequested"),
  @JsonSubTypes.Type(value = PaymentProcessed.class, name = "PaymentProcessed"),
  @JsonSubTypes.Type(value = PaymentRefunded.class, name = "PaymentRefunded"),
  @JsonSubTypes.Type(value = PaymentStarted.class, name = "PaymentStarted"),
  @JsonSubTypes.Type(value = RefundCreated.class, name = "RefundCreated"),
  @JsonSubTypes.Type(value = RefundFailed.class, name = "RefundFailed"),
  @JsonSubTypes.Type(value = RefundPending.class, name = "RefundPending"),
  @JsonSubTypes.Type(value = RefundSucceeded.class, name = "RefundSucceeded"),
})

public class InvoicePaid extends Event {
  public static final String JSON_PROPERTY_INVOICE = "invoice";
  private Invoice invoice;

  public InvoicePaid() { 
  }

  public InvoicePaid invoice(Invoice invoice) {
    
    this.invoice = invoice;
    return this;
  }

   /**
   * Get invoice
   * @return invoice
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INVOICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Invoice getInvoice() {
    return invoice;
  }


  @JsonProperty(JSON_PROPERTY_INVOICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInvoice(Invoice invoice) {
    this.invoice = invoice;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicePaid invoicePaid = (InvoicePaid) o;
    return Objects.equals(this.invoice, invoicePaid.invoice) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoice, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicePaid {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoice: ").append(toIndentedString(invoice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

