package dev.vality.swag_webhook_events.api;

import dev.vality.swag_webhook_events.ApiClient;

import dev.vality.swag_webhook_events.model.Event;
import dev.vality.swag_webhook_events.model.GeneralError;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-26T07:25:02.930733331Z[Etc/UTC]")
@Component("dev.vality.swag_webhook_events.api.EventNotificationsApi")
public class EventNotificationsApi {
    private ApiClient apiClient;

    public EventNotificationsApi() {
        this(new ApiClient());
    }

    @Autowired
    public EventNotificationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Notify of an event
     * 
     * <p><b>200</b> - Notification processed
     * <p><b>404</b> - Target resource not found
     * @param contentSignature Message signature formed according to the above rules  (required)
     * @param event Data from an event that occurred in the platform (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void notifyWebhookEvent(String contentSignature, Event event) throws RestClientException {
        notifyWebhookEventWithHttpInfo(contentSignature, event);
    }

    /**
     * Notify of an event
     * 
     * <p><b>200</b> - Notification processed
     * <p><b>404</b> - Target resource not found
     * @param contentSignature Message signature formed according to the above rules  (required)
     * @param event Data from an event that occurred in the platform (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> notifyWebhookEventWithHttpInfo(String contentSignature, Event event) throws RestClientException {
        Object postBody = event;
        
        // verify the required parameter 'contentSignature' is set
        if (contentSignature == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'contentSignature' when calling notifyWebhookEvent");
        }
        
        // verify the required parameter 'event' is set
        if (event == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'event' when calling notifyWebhookEvent");
        }
        

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (contentSignature != null)
        headerParams.add("Content-Signature", apiClient.parameterToString(contentSignature));

        final String[] localVarAccepts = { 
            "application/json; charset=utf-8"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] contentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] {  };

        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/webhook", HttpMethod.POST, Collections.<String, Object>emptyMap(), queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}
