/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import dev.vality.swag_webhook_events.model.PaymentToolDetailsCryptoWallet;
import dev.vality.swag_webhook_events.model.PaymentToolDetailsDigitalWallet;
import dev.vality.swag_webhook_events.model.PaymentToolDetailsMobileCommerce;
import dev.vality.swag_webhook_events.model.PaymentToolDetailsPaymentTerminal;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"bin", "lastDigits", "cardNumberMask", "paymentSystem", "tokenProvider", "tokenProviderName", "issuerCountry", "bankName"})
@JsonTypeName(value="PaymentToolDetailsBankCard")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="detailsType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PaymentToolDetailsBankCard.class, name="PaymentToolDetailsBankCard"), @JsonSubTypes.Type(value=PaymentToolDetailsCryptoWallet.class, name="PaymentToolDetailsCryptoWallet"), @JsonSubTypes.Type(value=PaymentToolDetailsDigitalWallet.class, name="PaymentToolDetailsDigitalWallet"), @JsonSubTypes.Type(value=PaymentToolDetailsMobileCommerce.class, name="PaymentToolDetailsMobileCommerce"), @JsonSubTypes.Type(value=PaymentToolDetailsPaymentTerminal.class, name="PaymentToolDetailsPaymentTerminal")})
public class PaymentToolDetailsBankCard
extends PaymentToolDetails {
    public static final String JSON_PROPERTY_BIN = "bin";
    private String bin;
    public static final String JSON_PROPERTY_LAST_DIGITS = "lastDigits";
    private String lastDigits;
    public static final String JSON_PROPERTY_CARD_NUMBER_MASK = "cardNumberMask";
    private String cardNumberMask;
    public static final String JSON_PROPERTY_PAYMENT_SYSTEM = "paymentSystem";
    private String paymentSystem;
    public static final String JSON_PROPERTY_TOKEN_PROVIDER = "tokenProvider";
    private TokenProviderEnum tokenProvider;
    public static final String JSON_PROPERTY_TOKEN_PROVIDER_NAME = "tokenProviderName";
    private String tokenProviderName;
    public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
    private String issuerCountry;
    public static final String JSON_PROPERTY_BANK_NAME = "bankName";
    private String bankName;

    public PaymentToolDetailsBankCard bin(String bin) {
        this.bin = bin;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Card issuing bank BIN")
    @JsonProperty(value="bin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBin() {
        return this.bin;
    }

    @JsonProperty(value="bin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBin(String bin) {
        this.bin = bin;
    }

    public PaymentToolDetailsBankCard lastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Card last digits")
    @JsonProperty(value="lastDigits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastDigits() {
        return this.lastDigits;
    }

    @JsonProperty(value="lastDigits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
    }

    public PaymentToolDetailsBankCard cardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Masked card number")
    @JsonProperty(value="cardNumberMask")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCardNumberMask() {
        return this.cardNumberMask;
    }

    @JsonProperty(value="cardNumberMask")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
    }

    public PaymentToolDetailsBankCard paymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Payment system")
    @JsonProperty(value="paymentSystem")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentSystem() {
        return this.paymentSystem;
    }

    @JsonProperty(value="paymentSystem")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public PaymentToolDetailsBankCard tokenProvider(TokenProviderEnum tokenProvider) {
        this.tokenProvider = tokenProvider;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="Payment token provider")
    @JsonProperty(value="tokenProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenProviderEnum getTokenProvider() {
        return this.tokenProvider;
    }

    @JsonProperty(value="tokenProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenProvider(TokenProviderEnum tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public PaymentToolDetailsBankCard tokenProviderName(String tokenProviderName) {
        this.tokenProviderName = tokenProviderName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Payment token provider")
    @JsonProperty(value="tokenProviderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenProviderName() {
        return this.tokenProviderName;
    }

    @JsonProperty(value="tokenProviderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenProviderName(String tokenProviderName) {
        this.tokenProviderName = tokenProviderName;
    }

    public PaymentToolDetailsBankCard issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"RUS\",\"POL\",\"USA\"]", value="Issuing country (alpha-3 code according to ISO_3166-1)")
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public PaymentToolDetailsBankCard bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"SBERBANK OF RUSSIA\",\"JOINT STOCK COMPANY ALFA-BANK\",\"VTB BANK OJSC\"]", value="Bank name")
    @JsonProperty(value="bankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankName() {
        return this.bankName;
    }

    @JsonProperty(value="bankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentToolDetailsBankCard paymentToolDetailsBankCard = (PaymentToolDetailsBankCard)o;
        return Objects.equals(this.bin, paymentToolDetailsBankCard.bin) && Objects.equals(this.lastDigits, paymentToolDetailsBankCard.lastDigits) && Objects.equals(this.cardNumberMask, paymentToolDetailsBankCard.cardNumberMask) && Objects.equals(this.paymentSystem, paymentToolDetailsBankCard.paymentSystem) && Objects.equals((Object)this.tokenProvider, (Object)paymentToolDetailsBankCard.tokenProvider) && Objects.equals(this.tokenProviderName, paymentToolDetailsBankCard.tokenProviderName) && Objects.equals(this.issuerCountry, paymentToolDetailsBankCard.issuerCountry) && Objects.equals(this.bankName, paymentToolDetailsBankCard.bankName) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.bin, this.lastDigits, this.cardNumberMask, this.paymentSystem, this.tokenProvider, this.tokenProviderName, this.issuerCountry, this.bankName, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentToolDetailsBankCard {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    lastDigits: ").append(this.toIndentedString(this.lastDigits)).append("\n");
        sb.append("    cardNumberMask: ").append(this.toIndentedString(this.cardNumberMask)).append("\n");
        sb.append("    paymentSystem: ").append(this.toIndentedString(this.paymentSystem)).append("\n");
        sb.append("    tokenProvider: ").append(this.toIndentedString((Object)this.tokenProvider)).append("\n");
        sb.append("    tokenProviderName: ").append(this.toIndentedString(this.tokenProviderName)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TokenProviderEnum {
        APPLEPAY("applepay"),
        GOOGLEPAY("googlepay"),
        SAMSUNGPAY("samsungpay"),
        YANDEXPAY("yandexpay"),
        UNKNOWN("unknown");

        private String value;

        private TokenProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenProviderEnum fromValue(String value) {
            for (TokenProviderEnum b : TokenProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

