/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.vality.swag_webhook_events.model.ClientInfo;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Payment tool details")
@JsonPropertyOrder(value={"paymentToolToken", "paymentSession", "paymentToolDetails", "clientInfo"})
@JsonTypeName(value="PaymentResource")
public class PaymentResource {
    public static final String JSON_PROPERTY_PAYMENT_TOOL_TOKEN = "paymentToolToken";
    private String paymentToolToken;
    public static final String JSON_PROPERTY_PAYMENT_SESSION = "paymentSession";
    private String paymentSession;
    public static final String JSON_PROPERTY_PAYMENT_TOOL_DETAILS = "paymentToolDetails";
    private PaymentToolDetails paymentToolDetails;
    public static final String JSON_PROPERTY_CLIENT_INFO = "clientInfo";
    private ClientInfo clientInfo;

    public PaymentResource paymentToolToken(String paymentToolToken) {
        this.paymentToolToken = paymentToolToken;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Payment tool token provided by the payer")
    @JsonProperty(value="paymentToolToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentToolToken() {
        return this.paymentToolToken;
    }

    @JsonProperty(value="paymentToolToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentToolToken(String paymentToolToken) {
        this.paymentToolToken = paymentToolToken;
    }

    public PaymentResource paymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Payment session identifier")
    @JsonProperty(value="paymentSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentSession() {
        return this.paymentSession;
    }

    @JsonProperty(value="paymentSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
    }

    public PaymentResource paymentToolDetails(PaymentToolDetails paymentToolDetails) {
        this.paymentToolDetails = paymentToolDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentToolDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentToolDetails getPaymentToolDetails() {
        return this.paymentToolDetails;
    }

    @JsonProperty(value="paymentToolDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
        this.paymentToolDetails = paymentToolDetails;
    }

    public PaymentResource clientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="clientInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    @JsonProperty(value="clientInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResource paymentResource = (PaymentResource)o;
        return Objects.equals(this.paymentToolToken, paymentResource.paymentToolToken) && Objects.equals(this.paymentSession, paymentResource.paymentSession) && Objects.equals(this.paymentToolDetails, paymentResource.paymentToolDetails) && Objects.equals(this.clientInfo, paymentResource.clientInfo);
    }

    public int hashCode() {
        return Objects.hash(this.paymentToolToken, this.paymentSession, this.paymentToolDetails, this.clientInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResource {\n");
        sb.append("    paymentToolToken: ").append(this.toIndentedString(this.paymentToolToken)).append("\n");
        sb.append("    paymentSession: ").append(this.toIndentedString(this.paymentSession)).append("\n");
        sb.append("    paymentToolDetails: ").append(this.toIndentedString(this.paymentToolDetails)).append("\n");
        sb.append("    clientInfo: ").append(this.toIndentedString(this.clientInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

