/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Payer;
import dev.vality.swag_webhook_events.model.PaymentContactInfo;
import dev.vality.swag_webhook_events.model.PaymentError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Invoice payment data")
@JsonPropertyOrder(value={"id", "createdAt", "status", "error", "amount", "changedAmount", "currency", "metadata", "paymentToolToken", "paymentSession", "contactInfo", "ip", "fingerprint", "payer", "fee", "rrn", "externalId", "extraPaymentInfo"})
@JsonTypeName(value="Payment")
public class Payment {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_ERROR = "error";
    private PaymentError error;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Long amount;
    public static final String JSON_PROPERTY_CHANGED_AMOUNT = "changedAmount";
    private Long changedAmount;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Object metadata;
    public static final String JSON_PROPERTY_PAYMENT_TOOL_TOKEN = "paymentToolToken";
    private String paymentToolToken;
    public static final String JSON_PROPERTY_PAYMENT_SESSION = "paymentSession";
    private String paymentSession;
    public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
    private PaymentContactInfo contactInfo;
    public static final String JSON_PROPERTY_IP = "ip";
    private String ip;
    public static final String JSON_PROPERTY_FINGERPRINT = "fingerprint";
    private String fingerprint;
    public static final String JSON_PROPERTY_PAYER = "payer";
    private Payer payer;
    public static final String JSON_PROPERTY_FEE = "fee";
    private Long fee;
    public static final String JSON_PROPERTY_RRN = "rrn";
    private String rrn;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;
    public static final String JSON_PROPERTY_EXTRA_PAYMENT_INFO = "extraPaymentInfo";
    private Object extraPaymentInfo;

    public Payment id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Payment ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public Payment createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Date and time of creation")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Payment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Payment status")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Payment error(PaymentError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentError getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(PaymentError error) {
        this.error = error;
    }

    public Payment amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The price of the goods or services offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Payment changedAmount(Long changedAmount) {
        this.changedAmount = changedAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Changed payment amount on the provider side ")
    @JsonProperty(value="changedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getChangedAmount() {
        return this.changedAmount;
    }

    @JsonProperty(value="changedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangedAmount(Long changedAmount) {
        this.changedAmount = changedAmount;
    }

    public Payment currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Payment metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Payment metadata")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Payment paymentToolToken(String paymentToolToken) {
        this.paymentToolToken = paymentToolToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Deprecated.** _Use the `payer` property._  Payment tool token ")
    @JsonProperty(value="paymentToolToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentToolToken() {
        return this.paymentToolToken;
    }

    @JsonProperty(value="paymentToolToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentToolToken(String paymentToolToken) {
        this.paymentToolToken = paymentToolToken;
    }

    public Payment paymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="**Deprecated.** _Use the `payer` property._  Payment session identifier ")
    @JsonProperty(value="paymentSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPaymentSession() {
        return this.paymentSession;
    }

    @JsonProperty(value="paymentSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
    }

    public Payment contactInfo(PaymentContactInfo contactInfo) {
        this.contactInfo = contactInfo;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contactInfo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PaymentContactInfo getContactInfo() {
        return this.contactInfo;
    }

    @JsonProperty(value="contactInfo")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContactInfo(PaymentContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    public Payment ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Deprecated.** _Use the `payer` property._  Payer's IP-address ")
    @JsonProperty(value="ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIp() {
        return this.ip;
    }

    @JsonProperty(value="ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIp(String ip) {
        this.ip = ip;
    }

    public Payment fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Deprecated.** _Use the `payer` property._  Payer's fingerprint ")
    @JsonProperty(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFingerprint() {
        return this.fingerprint;
    }

    @JsonProperty(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public Payment payer(Payer payer) {
        this.payer = payer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="payer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Payer getPayer() {
        return this.payer;
    }

    @JsonProperty(value="payer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public Payment fee(Long fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="System fee in minor monetary units. ")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Payment rrn(String rrn) {
        this.rrn = rrn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Retrieval reference number ")
    @JsonProperty(value="rrn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRrn() {
        return this.rrn;
    }

    @JsonProperty(value="rrn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRrn(String rrn) {
        this.rrn = rrn;
    }

    public Payment externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Merchant's transaction identifier")
    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Payment extraPaymentInfo(Object extraPaymentInfo) {
        this.extraPaymentInfo = extraPaymentInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Additional details about the payment, e.g. masked payer's card number. ")
    @JsonProperty(value="extraPaymentInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtraPaymentInfo() {
        return this.extraPaymentInfo;
    }

    @JsonProperty(value="extraPaymentInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtraPaymentInfo(Object extraPaymentInfo) {
        this.extraPaymentInfo = extraPaymentInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.id, payment.id) && Objects.equals(this.createdAt, payment.createdAt) && Objects.equals((Object)this.status, (Object)payment.status) && Objects.equals(this.error, payment.error) && Objects.equals(this.amount, payment.amount) && Objects.equals(this.changedAmount, payment.changedAmount) && Objects.equals(this.currency, payment.currency) && Objects.equals(this.metadata, payment.metadata) && Objects.equals(this.paymentToolToken, payment.paymentToolToken) && Objects.equals(this.paymentSession, payment.paymentSession) && Objects.equals(this.contactInfo, payment.contactInfo) && Objects.equals(this.ip, payment.ip) && Objects.equals(this.fingerprint, payment.fingerprint) && Objects.equals(this.payer, payment.payer) && Objects.equals(this.fee, payment.fee) && Objects.equals(this.rrn, payment.rrn) && Objects.equals(this.externalId, payment.externalId) && Objects.equals(this.extraPaymentInfo, payment.extraPaymentInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdAt, this.status, this.error, this.amount, this.changedAmount, this.currency, this.metadata, this.paymentToolToken, this.paymentSession, this.contactInfo, this.ip, this.fingerprint, this.payer, this.fee, this.rrn, this.externalId, this.extraPaymentInfo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    changedAmount: ").append(this.toIndentedString(this.changedAmount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    paymentToolToken: ").append(this.toIndentedString(this.paymentToolToken)).append("\n");
        sb.append("    paymentSession: ").append(this.toIndentedString(this.paymentSession)).append("\n");
        sb.append("    contactInfo: ").append(this.toIndentedString(this.contactInfo)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("    payer: ").append(this.toIndentedString(this.payer)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    rrn: ").append(this.toIndentedString(this.rrn)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    extraPaymentInfo: ").append(this.toIndentedString(this.extraPaymentInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        PROCESSED("processed"),
        CAPTURED("captured"),
        CANCELLED("cancelled"),
        REFUNDED("refunded"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

