/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.api;

import dev.vality.swag_webhook_events.ApiClient;
import dev.vality.swag_webhook_events.model.Event;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="dev.vality.swag_webhook_events.api.EventNotificationsApi")
public class EventNotificationsApi {
    private ApiClient apiClient;

    public EventNotificationsApi() {
        this(new ApiClient());
    }

    @Autowired
    public EventNotificationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void notifyWebhookEvent(String contentSignature, Event event) throws RestClientException {
        this.notifyWebhookEventWithHttpInfo(contentSignature, event);
    }

    public ResponseEntity<Void> notifyWebhookEventWithHttpInfo(String contentSignature, Event event) throws RestClientException {
        Event postBody = event;
        if (contentSignature == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'contentSignature' when calling notifyWebhookEvent");
        }
        if (event == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'event' when calling notifyWebhookEvent");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (contentSignature != null) {
            headerParams.add("Content-Signature", this.apiClient.parameterToString(contentSignature));
        }
        String[] localVarAccepts = new String[]{"application/json; charset=utf-8"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{};
        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/webhook", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

