/*
 * Vality Webhooks Events API
 * ## Payment Webhook Events API  The specification defines a protocol for delivering notifications about new payment events within your organisation. The notifications are deliveried by the system as HTTP requests to the URL of webhooks you created. Handlers for such kind of queries should be implemented on the side of your server code according to the specification.  Webhook is a subscription to a specific type of event or group of events relating to different objects within your organisation. API methods described in the specification [Payment Webhook Management API](https://github.com/valitydev/swag-payments) are used to manage webhooks.  When within the wallet one of the events occurs (e.g. a wallet status change), the system selects a webhook matching that event type and sends an HTTP request containing a JSON message to the URL specified in the webhook. If several webhooks matching this event type were created, the event is simultaneously delivered to all URLs specified in those webhooks in an undefined order. ## Delivery strategy The system guarantees events delivery order within a specific notification subject (invoice, payment, refund, etc.). The system maintains a message queue for each notification item to keep the sequence and ensure the guaranteed delivery.  A delivery request is considered to be successful only when a response with status `200` is received. The system will wait for a successful response to the sent a request during 10 seconds. In case of a response with any other status or after expiration of the specified time which was reserved to process the notification, the system will try to re-deliver notifications until a successful response is received, or until a decision is made that it is impossible to deliver information. Delivery attempts will be made at the following time intervals between requests:    - 30 seconds,    - 5 minutes,    - 15 minutes,    - 1 hour.    - every hour within 24 hours  If the last attempt of notification delivery fails, all the events that have been accumulated in this payment queue are discarded. ## Received messages authorization The system confirms notifications authenticity by signing messages with a private key that is unique to each webhook, the paired public key of which is contained in the data of that webhook. The signature is transmitted in the HTTP header Content-Signature. Represented in various atributes the header contains the information about the algorithm used to create a signature and content of the signature in the format [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  At the moment the only one signature generation alorithm is possible to use. ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3) The signature is generated according to [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2) algorithm , which itself uses result of message [SHA-256](https://tools.ietf.org/html/rfc6234) calculation.  The set of header attributes and the list of possible signature generation algorithms can be expanded later. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.InvoiceCartLineTaxMode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Product or service item
 */
@ApiModel(description = "Product or service item")
@JsonPropertyOrder({
  InvoiceCartLine.JSON_PROPERTY_PRODUCT,
  InvoiceCartLine.JSON_PROPERTY_QUANTITY,
  InvoiceCartLine.JSON_PROPERTY_PRICE,
  InvoiceCartLine.JSON_PROPERTY_COST,
  InvoiceCartLine.JSON_PROPERTY_TAX_MODE
})
@JsonTypeName("InvoiceCartLine")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-24T11:28:30.180998085Z[Etc/UTC]")
public class InvoiceCartLine {
  public static final String JSON_PROPERTY_PRODUCT = "product";
  private String product;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Long quantity = 1l;

  public static final String JSON_PROPERTY_PRICE = "price";
  private Long price;

  public static final String JSON_PROPERTY_COST = "cost";
  private Long cost;

  public static final String JSON_PROPERTY_TAX_MODE = "taxMode";
  private InvoiceCartLineTaxMode taxMode;

  public InvoiceCartLine() { 
  }

  public InvoiceCartLine product(String product) {
    
    this.product = product;
    return this;
  }

   /**
   * Description of the goods or services offered
   * @return product
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Description of the goods or services offered")
  @JsonProperty(JSON_PROPERTY_PRODUCT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProduct() {
    return product;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProduct(String product) {
    this.product = product;
  }


  public InvoiceCartLine quantity(Long quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Number of units of goods or services offered in this item 
   * minimum: 1
   * @return quantity
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Number of units of goods or services offered in this item ")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }


  public InvoiceCartLine price(Long price) {
    
    this.price = price;
    return this;
  }

   /**
   * The price of the good or service offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency 
   * minimum: 1
   * @return price
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "The price of the good or service offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(Long price) {
    this.price = price;
  }


  public InvoiceCartLine cost(Long cost) {
    
    this.cost = cost;
    return this;
  }

   /**
   * The total value of the item, taking into account the number of units of goods or services 
   * minimum: 1
   * @return cost
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "The total value of the item, taking into account the number of units of goods or services ")
  @JsonProperty(JSON_PROPERTY_COST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getCost() {
    return cost;
  }


  @JsonProperty(JSON_PROPERTY_COST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCost(Long cost) {
    this.cost = cost;
  }


  public InvoiceCartLine taxMode(InvoiceCartLineTaxMode taxMode) {
    
    this.taxMode = taxMode;
    return this;
  }

   /**
   * Get taxMode
   * @return taxMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TAX_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InvoiceCartLineTaxMode getTaxMode() {
    return taxMode;
  }


  @JsonProperty(JSON_PROPERTY_TAX_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxMode(InvoiceCartLineTaxMode taxMode) {
    this.taxMode = taxMode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceCartLine invoiceCartLine = (InvoiceCartLine) o;
    return Objects.equals(this.product, invoiceCartLine.product) &&
        Objects.equals(this.quantity, invoiceCartLine.quantity) &&
        Objects.equals(this.price, invoiceCartLine.price) &&
        Objects.equals(this.cost, invoiceCartLine.cost) &&
        Objects.equals(this.taxMode, invoiceCartLine.taxMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, quantity, price, cost, taxMode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceCartLine {\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    cost: ").append(toIndentedString(cost)).append("\n");
    sb.append("    taxMode: ").append(toIndentedString(taxMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

