/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.RefundError;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="Refund", description="Refund data within the payment")
public class Refund {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="createdAt")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="error")
    private RefundError error;
    @JsonProperty(value="amount")
    private Long amount;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="reason")
    private String reason;
    @JsonProperty(value="rrn")
    private String rrn;

    public Refund id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="Refund identifier", required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Refund createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="createdAt", description="Date and time of creation", required=true)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Refund status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @Schema(name="status", description="Refund status", required=true)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Refund error(RefundError error) {
        this.error = error;
        return this;
    }

    @Valid
    @Schema(name="error", required=false)
    public RefundError getError() {
        return this.error;
    }

    public void setError(RefundError error) {
        this.error = error;
    }

    public Refund amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @Schema(name="amount", description="Refund amount in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ", required=true)
    public @NotNull @Min(value=1L) Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Refund currency(String currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Schema(name="currency", description="Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ", required=true)
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Refund reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Schema(name="reason", description="Refund reason", required=false)
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Refund rrn(String rrn) {
        this.rrn = rrn;
        return this;
    }

    @Schema(name="rrn", description="Retrieval reference number ", required=false)
    public String getRrn() {
        return this.rrn;
    }

    public void setRrn(String rrn) {
        this.rrn = rrn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Refund refund = (Refund)o;
        return Objects.equals(this.id, refund.id) && Objects.equals(this.createdAt, refund.createdAt) && Objects.equals((Object)this.status, (Object)refund.status) && Objects.equals(this.error, refund.error) && Objects.equals(this.amount, refund.amount) && Objects.equals(this.currency, refund.currency) && Objects.equals(this.reason, refund.reason) && Objects.equals(this.rrn, refund.rrn);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdAt, this.status, this.error, this.amount, this.currency, this.reason, this.rrn});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Refund {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    rrn: ").append(this.toIndentedString(this.rrn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        SUCCEEDED("succeeded"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

