/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class PaymentToolDetailsBankCard
extends PaymentToolDetails {
    @JsonProperty(value="bin")
    private String bin;
    @JsonProperty(value="lastDigits")
    private String lastDigits;
    @JsonProperty(value="cardNumberMask")
    private String cardNumberMask;
    @JsonProperty(value="paymentSystem")
    private String paymentSystem;
    @JsonProperty(value="tokenProvider")
    private TokenProviderEnum tokenProvider;
    @JsonProperty(value="tokenProviderName")
    private String tokenProviderName;
    @JsonProperty(value="issuerCountry")
    private String issuerCountry;
    @JsonProperty(value="bankName")
    private String bankName;

    public PaymentToolDetailsBankCard bin(String bin) {
        this.bin = bin;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\d{6,8}$")
    @Schema(name="bin", description="Card issuing bank BIN", required=true)
    public @NotNull @Pattern(regexp="^\\d{6,8}$") String getBin() {
        return this.bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public PaymentToolDetailsBankCard lastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\d{2,4}$")
    @Schema(name="lastDigits", description="Card last digits", required=true)
    public @NotNull @Pattern(regexp="^\\d{2,4}$") String getLastDigits() {
        return this.lastDigits;
    }

    public void setLastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
    }

    public PaymentToolDetailsBankCard cardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\d{6,8}\\*+\\d{2,4}$")
    @Schema(name="cardNumberMask", description="Masked card number", required=true)
    public @NotNull @Pattern(regexp="^\\d{6,8}\\*+\\d{2,4}$") String getCardNumberMask() {
        return this.cardNumberMask;
    }

    public void setCardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
    }

    public PaymentToolDetailsBankCard paymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
        return this;
    }

    @NotNull
    @Size(max=100)
    @Schema(name="paymentSystem", description="Payment system", required=true)
    public @NotNull @Size(max=100) String getPaymentSystem() {
        return this.paymentSystem;
    }

    public void setPaymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public PaymentToolDetailsBankCard tokenProvider(TokenProviderEnum tokenProvider) {
        this.tokenProvider = tokenProvider;
        return this;
    }

    @Schema(name="tokenProvider", description="Payment token provider", required=false)
    public TokenProviderEnum getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTokenProvider(TokenProviderEnum tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public PaymentToolDetailsBankCard tokenProviderName(String tokenProviderName) {
        this.tokenProviderName = tokenProviderName;
        return this;
    }

    @Schema(name="tokenProviderName", description="Payment token provider", required=false)
    public String getTokenProviderName() {
        return this.tokenProviderName;
    }

    public void setTokenProviderName(String tokenProviderName) {
        this.tokenProviderName = tokenProviderName;
    }

    public PaymentToolDetailsBankCard issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @Schema(name="issuerCountry", example="[\"RUS\",\"POL\",\"USA\"]", description="Issuing country (alpha-3 code according to ISO_3166-1)", required=false)
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public PaymentToolDetailsBankCard bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @Schema(name="bankName", example="[\"SBERBANK OF RUSSIA\",\"JOINT STOCK COMPANY ALFA-BANK\",\"VTB BANK OJSC\"]", description="Bank name", required=false)
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentToolDetailsBankCard paymentToolDetailsBankCard = (PaymentToolDetailsBankCard)o;
        return Objects.equals(this.bin, paymentToolDetailsBankCard.bin) && Objects.equals(this.lastDigits, paymentToolDetailsBankCard.lastDigits) && Objects.equals(this.cardNumberMask, paymentToolDetailsBankCard.cardNumberMask) && Objects.equals(this.paymentSystem, paymentToolDetailsBankCard.paymentSystem) && Objects.equals((Object)this.tokenProvider, (Object)paymentToolDetailsBankCard.tokenProvider) && Objects.equals(this.tokenProviderName, paymentToolDetailsBankCard.tokenProviderName) && Objects.equals(this.issuerCountry, paymentToolDetailsBankCard.issuerCountry) && Objects.equals(this.bankName, paymentToolDetailsBankCard.bankName) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.bin, this.lastDigits, this.cardNumberMask, this.paymentSystem, this.tokenProvider, this.tokenProviderName, this.issuerCountry, this.bankName, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentToolDetailsBankCard {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    lastDigits: ").append(this.toIndentedString(this.lastDigits)).append("\n");
        sb.append("    cardNumberMask: ").append(this.toIndentedString(this.cardNumberMask)).append("\n");
        sb.append("    paymentSystem: ").append(this.toIndentedString(this.paymentSystem)).append("\n");
        sb.append("    tokenProvider: ").append(this.toIndentedString((Object)this.tokenProvider)).append("\n");
        sb.append("    tokenProviderName: ").append(this.toIndentedString(this.tokenProviderName)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TokenProviderEnum {
        APPLEPAY("applepay"),
        GOOGLEPAY("googlepay"),
        SAMSUNGPAY("samsungpay"),
        YANDEXPAY("yandexpay"),
        UNKNOWN("unknown");

        private String value;

        private TokenProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenProviderEnum fromValue(String value) {
            for (TokenProviderEnum b : TokenProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

