/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag_webhook_events.model.ClientInfo;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(name="PaymentResource", description="Payment tool details")
public class PaymentResource {
    @JsonProperty(value="paymentToolToken")
    private String paymentToolToken;
    @JsonProperty(value="paymentSession")
    private String paymentSession;
    @JsonProperty(value="paymentToolDetails")
    private PaymentToolDetails paymentToolDetails;
    @JsonProperty(value="clientInfo")
    private ClientInfo clientInfo;

    public PaymentResource paymentToolToken(String paymentToolToken) {
        this.paymentToolToken = paymentToolToken;
        return this;
    }

    @NotNull
    @Size(max=1000)
    @Schema(name="paymentToolToken", description="Payment tool token provided by the payer", required=true)
    public @NotNull @Size(max=1000) String getPaymentToolToken() {
        return this.paymentToolToken;
    }

    public void setPaymentToolToken(String paymentToolToken) {
        this.paymentToolToken = paymentToolToken;
    }

    public PaymentResource paymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
        return this;
    }

    @NotNull
    @Size(max=1000)
    @Schema(name="paymentSession", description="Payment session identifier", required=true)
    public @NotNull @Size(max=1000) String getPaymentSession() {
        return this.paymentSession;
    }

    public void setPaymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
    }

    public PaymentResource paymentToolDetails(PaymentToolDetails paymentToolDetails) {
        this.paymentToolDetails = paymentToolDetails;
        return this;
    }

    @Valid
    @Schema(name="paymentToolDetails", required=false)
    public PaymentToolDetails getPaymentToolDetails() {
        return this.paymentToolDetails;
    }

    public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
        this.paymentToolDetails = paymentToolDetails;
    }

    public PaymentResource clientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        return this;
    }

    @Valid
    @Schema(name="clientInfo", required=false)
    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResource paymentResource = (PaymentResource)o;
        return Objects.equals(this.paymentToolToken, paymentResource.paymentToolToken) && Objects.equals(this.paymentSession, paymentResource.paymentSession) && Objects.equals(this.paymentToolDetails, paymentResource.paymentToolDetails) && Objects.equals(this.clientInfo, paymentResource.clientInfo);
    }

    public int hashCode() {
        return Objects.hash(this.paymentToolToken, this.paymentSession, this.paymentToolDetails, this.clientInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResource {\n");
        sb.append("    paymentToolToken: ").append(this.toIndentedString(this.paymentToolToken)).append("\n");
        sb.append("    paymentSession: ").append(this.toIndentedString(this.paymentSession)).append("\n");
        sb.append("    paymentToolDetails: ").append(this.toIndentedString(this.paymentToolDetails)).append("\n");
        sb.append("    clientInfo: ").append(this.toIndentedString(this.clientInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

