/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.InvoiceCartLine;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="Invoice", description="Invoice data")
public class Invoice {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="shopID")
    private String shopID;
    @JsonProperty(value="createdAt")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="reason")
    private String reason;
    @JsonProperty(value="dueDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime dueDate;
    @JsonProperty(value="amount")
    private Long amount;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="metadata")
    private Object metadata;
    @JsonProperty(value="product")
    private String product;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="cart")
    @Valid
    private List<InvoiceCartLine> cart = null;
    @JsonProperty(value="externalId")
    private String externalId;

    public Invoice id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="Invoice ID", required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Invoice shopID(String shopID) {
        this.shopID = shopID;
        return this;
    }

    @NotNull
    @Schema(name="shopID", description="Shop ID", required=true)
    public String getShopID() {
        return this.shopID;
    }

    public void setShopID(String shopID) {
        this.shopID = shopID;
    }

    public Invoice createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="createdAt", description="Date and time of creation", required=true)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Invoice status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @Schema(name="status", description="Invoice status", required=true)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Invoice reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Schema(name="reason", description="Reason for invoice cancellation or redemption", required=false)
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Invoice dueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="dueDate", description="Expiration date and time", required=true)
    public OffsetDateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public Invoice amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @Schema(name="amount", description="The price of the goods or services offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ", required=true)
    public @NotNull @Min(value=1L) Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Invoice currency(String currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Schema(name="currency", description="Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ", required=true)
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Invoice metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @NotNull
    @Schema(name="metadata", description="Invoice metadata", required=true)
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Invoice product(String product) {
        this.product = product;
        return this;
    }

    @NotNull
    @Schema(name="product", description="Name of the offered goods or services", required=true)
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public Invoice description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description of the goods or services offered", required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Invoice cart(List<InvoiceCartLine> cart) {
        this.cart = cart;
        return this;
    }

    public Invoice addCartItem(InvoiceCartLine cartItem) {
        if (this.cart == null) {
            this.cart = new ArrayList<InvoiceCartLine>();
        }
        this.cart.add(cartItem);
        return this;
    }

    @Valid
    @Size(min=1, max=100)
    @Schema(name="cart", description="A shopping cart with a list of items of provided goods or services ", required=false)
    public @Valid @Size(min=1, max=100) List<InvoiceCartLine> getCart() {
        return this.cart;
    }

    public void setCart(List<InvoiceCartLine> cart) {
        this.cart = cart;
    }

    public Invoice externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(name="externalId", description="Merchant's transaction identifier", required=false)
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        return Objects.equals(this.id, invoice.id) && Objects.equals(this.shopID, invoice.shopID) && Objects.equals(this.createdAt, invoice.createdAt) && Objects.equals((Object)this.status, (Object)invoice.status) && Objects.equals(this.reason, invoice.reason) && Objects.equals(this.dueDate, invoice.dueDate) && Objects.equals(this.amount, invoice.amount) && Objects.equals(this.currency, invoice.currency) && Objects.equals(this.metadata, invoice.metadata) && Objects.equals(this.product, invoice.product) && Objects.equals(this.description, invoice.description) && Objects.equals(this.cart, invoice.cart) && Objects.equals(this.externalId, invoice.externalId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.shopID, this.createdAt, this.status, this.reason, this.dueDate, this.amount, this.currency, this.metadata, this.product, this.description, this.cart, this.externalId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invoice {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    shopID: ").append(this.toIndentedString(this.shopID)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    cart: ").append(this.toIndentedString(this.cart)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UNPAID("unpaid"),
        CANCELLED("cancelled"),
        PAID("paid"),
        REFUNDED("refunded"),
        FULFILLED("fulfilled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

