/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag_webhook_events.model.Customer;
import dev.vality.swag_webhook_events.model.CustomerBinding;
import dev.vality.swag_webhook_events.model.Event;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Schema(name="CustomerBindingFailed", description="Event about unsuccessful binding of the customer to the payment tool")
public class CustomerBindingFailed
extends Event {
    @JsonProperty(value="customer")
    private Customer customer;
    @JsonProperty(value="binding")
    private CustomerBinding binding;

    public CustomerBindingFailed customer(Customer customer) {
        this.customer = customer;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="customer", required=true)
    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public CustomerBindingFailed binding(CustomerBinding binding) {
        this.binding = binding;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="binding", required=true)
    public CustomerBinding getBinding() {
        return this.binding;
    }

    public void setBinding(CustomerBinding binding) {
        this.binding = binding;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerBindingFailed customerBindingFailed = (CustomerBindingFailed)o;
        return Objects.equals(this.customer, customerBindingFailed.customer) && Objects.equals(this.binding, customerBindingFailed.binding) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.customer, this.binding, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerBindingFailed {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    customer: ").append(this.toIndentedString(this.customer)).append("\n");
        sb.append("    binding: ").append(this.toIndentedString(this.binding)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

