/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.CustomerBindingError;
import dev.vality.swag_webhook_events.model.PaymentResource;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Schema(name="CustomerBinding", description="Binding of the customer to the payment tool")
public class CustomerBinding {
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="error")
    private CustomerBindingError error;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="paymentResource")
    private PaymentResource paymentResource;

    public CustomerBinding status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @Schema(name="status", description="Binding status", required=true)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CustomerBinding error(CustomerBindingError error) {
        this.error = error;
        return this;
    }

    @Valid
    @Schema(name="error", required=false)
    public CustomerBindingError getError() {
        return this.error;
    }

    public void setError(CustomerBindingError error) {
        this.error = error;
    }

    public CustomerBinding id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="Customer binding identifier", required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CustomerBinding paymentResource(PaymentResource paymentResource) {
        this.paymentResource = paymentResource;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="paymentResource", required=true)
    public PaymentResource getPaymentResource() {
        return this.paymentResource;
    }

    public void setPaymentResource(PaymentResource paymentResource) {
        this.paymentResource = paymentResource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerBinding customerBinding = (CustomerBinding)o;
        return Objects.equals((Object)this.status, (Object)customerBinding.status) && Objects.equals(this.error, customerBinding.error) && Objects.equals(this.id, customerBinding.id) && Objects.equals(this.paymentResource, customerBinding.paymentResource);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.error, this.id, this.paymentResource});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerBinding {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentResource: ").append(this.toIndentedString(this.paymentResource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        SUCCEEDED("succeeded"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

