/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(name="ClientInfo", description="Payer's client device data")
public class ClientInfo {
    @JsonProperty(value="ip")
    private String ip;
    @JsonProperty(value="fingerprint")
    private String fingerprint;

    public ClientInfo ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Size(max=45)
    @Schema(name="ip", description="Payer IP-address", required=false)
    public @Size(max=45) String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public ClientInfo fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @NotNull
    @Size(max=1000)
    @Schema(name="fingerprint", description="Payer's user agent unique fingerprint", required=true)
    public @NotNull @Size(max=1000) String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientInfo clientInfo = (ClientInfo)o;
        return Objects.equals(this.ip, clientInfo.ip) && Objects.equals(this.fingerprint, clientInfo.fingerprint);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.fingerprint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientInfo {\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

