package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.RefundError;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Refund data within the payment
 */

@Schema(name = "Refund", description = "Refund data within the payment")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-08-08T11:27:10.986689983Z[Etc/UTC]")
public class Refund   {

  @JsonProperty("id")
  private String id;

  @JsonProperty("createdAt")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  /**
   * Refund status
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    SUCCEEDED("succeeded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("error")
  private RefundError error;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("reason")
  private String reason;

  @JsonProperty("rrn")
  private String rrn;

  public Refund id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Refund identifier
   * @return id
  */
  @NotNull 
  @Schema(name = "id", description = "Refund identifier", required = true)
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Refund createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Date and time of creation
   * @return createdAt
  */
  @NotNull @Valid 
  @Schema(name = "createdAt", description = "Date and time of creation", required = true)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Refund status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Refund status
   * @return status
  */
  @NotNull 
  @Schema(name = "status", description = "Refund status", required = true)
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Refund error(RefundError error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  */
  @Valid 
  @Schema(name = "error", required = false)
  public RefundError getError() {
    return error;
  }

  public void setError(RefundError error) {
    this.error = error;
  }

  public Refund amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Refund amount in minor monetary units, e.g. cents if U.S. dollars are specified as the currency 
   * minimum: 1
   * @return amount
  */
  @NotNull @Min(1L) 
  @Schema(name = "amount", description = "Refund amount in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ", required = true)
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public Refund currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  */
  @NotNull 
  @Schema(name = "currency", description = "Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ", required = true)
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Refund reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * Refund reason
   * @return reason
  */
  
  @Schema(name = "reason", description = "Refund reason", required = false)
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public Refund rrn(String rrn) {
    this.rrn = rrn;
    return this;
  }

  /**
   * Retrieval reference number 
   * @return rrn
  */
  
  @Schema(name = "rrn", description = "Retrieval reference number ", required = false)
  public String getRrn() {
    return rrn;
  }

  public void setRrn(String rrn) {
    this.rrn = rrn;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Refund refund = (Refund) o;
    return Objects.equals(this.id, refund.id) &&
        Objects.equals(this.createdAt, refund.createdAt) &&
        Objects.equals(this.status, refund.status) &&
        Objects.equals(this.error, refund.error) &&
        Objects.equals(this.amount, refund.amount) &&
        Objects.equals(this.currency, refund.currency) &&
        Objects.equals(this.reason, refund.reason) &&
        Objects.equals(this.rrn, refund.rrn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, status, error, amount, currency, reason, rrn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Refund {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    rrn: ").append(toIndentedString(rrn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

