package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag_webhook_events.model.SubError;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * [Error occurred during the payment process](#tag/Error-Codes) 
 */

@Schema(name = "PaymentError", description = "[Error occurred during the payment process](#tag/Error-Codes) ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-08-08T11:27:10.986689983Z[Etc/UTC]")
public class PaymentError   {

  @JsonProperty("code")
  private String code;

  @JsonProperty("message")
  private String message;

  @JsonProperty("subError")
  private SubError subError;

  public PaymentError code(String code) {
    this.code = code;
    return this;
  }

  /**
   * Basic error code
   * @return code
  */
  @NotNull 
  @Schema(name = "code", description = "Basic error code", required = true)
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public PaymentError message(String message) {
    this.message = message;
    return this;
  }

  /**
   * **Deprecated.** _Use `subError` to detail the error description._ Error description 
   * @return message
  */
  @NotNull 
  @Schema(name = "message", description = "**Deprecated.** _Use `subError` to detail the error description._ Error description ", required = true)
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public PaymentError subError(SubError subError) {
    this.subError = subError;
    return this;
  }

  /**
   * Get subError
   * @return subError
  */
  @Valid 
  @Schema(name = "subError", required = false)
  public SubError getSubError() {
    return subError;
  }

  public void setSubError(SubError subError) {
    this.subError = subError;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentError paymentError = (PaymentError) o;
    return Objects.equals(this.code, paymentError.code) &&
        Objects.equals(this.message, paymentError.message) &&
        Objects.equals(this.subError, paymentError.subError);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, subError);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentError {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    subError: ").append(toIndentedString(subError)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

