package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * The tax mode for the proposed good or service.To be specified only if the proposed good or service is taxable. 
 */

@Schema(name = "InvoiceCartLine_taxMode", description = "The tax mode for the proposed good or service.To be specified only if the proposed good or service is taxable. ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-08-08T11:27:10.986689983Z[Etc/UTC]")
public class InvoiceCartLineTaxMode   {

  /**
   * VAT rate
   */
  public enum RateEnum {
    _0_("0%"),
    
    _10_("10%"),
    
    _18_("18%"),
    
    _20_("20%"),
    
    _10_110("10/110"),
    
    _18_118("18/118"),
    
    _20_120("20/120");

    private String value;

    RateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateEnum fromValue(String value) {
      for (RateEnum b : RateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("rate")
  private RateEnum rate;

  public InvoiceCartLineTaxMode rate(RateEnum rate) {
    this.rate = rate;
    return this;
  }

  /**
   * VAT rate
   * @return rate
  */
  @NotNull 
  @Schema(name = "rate", description = "VAT rate", required = true)
  public RateEnum getRate() {
    return rate;
  }

  public void setRate(RateEnum rate) {
    this.rate = rate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceCartLineTaxMode invoiceCartLineTaxMode = (InvoiceCartLineTaxMode) o;
    return Objects.equals(this.rate, invoiceCartLineTaxMode.rate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceCartLineTaxMode {\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

