package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.DigitalWalletDetails;
import dev.vality.swag_webhook_events.model.DigitalWalletDetailsQIWIAllOf;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DigitalWalletDetailsQIWI
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-08-08T11:27:10.986689983Z[Etc/UTC]")
public class DigitalWalletDetailsQIWI extends DigitalWalletDetails  {

  @JsonProperty("phoneNumberMask")
  private String phoneNumberMask;

  public DigitalWalletDetailsQIWI phoneNumberMask(String phoneNumberMask) {
    this.phoneNumberMask = phoneNumberMask;
    return this;
  }

  /**
   * Masked phone number of the payer in international format 
   * @return phoneNumberMask
  */
  @NotNull @Pattern(regexp = "^\\+\\d\\*{1,10}\\d{2,4}$") 
  @Schema(name = "phoneNumberMask", example = "+7******3210", description = "Masked phone number of the payer in international format ", required = true)
  public String getPhoneNumberMask() {
    return phoneNumberMask;
  }

  public void setPhoneNumberMask(String phoneNumberMask) {
    this.phoneNumberMask = phoneNumberMask;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DigitalWalletDetailsQIWI digitalWalletDetailsQIWI = (DigitalWalletDetailsQIWI) o;
    return Objects.equals(this.phoneNumberMask, digitalWalletDetailsQIWI.phoneNumberMask) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phoneNumberMask, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DigitalWalletDetailsQIWI {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    phoneNumberMask: ").append(toIndentedString(phoneNumberMask)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

