package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * Payer&#39;s client device data
 */

@Schema(name = "ClientInfo", description = "Payer's client device data")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-08-08T11:27:10.986689983Z[Etc/UTC]")
public class ClientInfo   {

  @JsonProperty("ip")
  private String ip;

  @JsonProperty("fingerprint")
  private String fingerprint;

  public ClientInfo ip(String ip) {
    this.ip = ip;
    return this;
  }

  /**
   * Payer IP-address
   * @return ip
  */
  @Size(max = 45) 
  @Schema(name = "ip", description = "Payer IP-address", required = false)
  public String getIp() {
    return ip;
  }

  public void setIp(String ip) {
    this.ip = ip;
  }

  public ClientInfo fingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Payer's user agent unique fingerprint
   * @return fingerprint
  */
  @NotNull @Size(max = 1000) 
  @Schema(name = "fingerprint", description = "Payer's user agent unique fingerprint", required = true)
  public String getFingerprint() {
    return fingerprint;
  }

  public void setFingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientInfo clientInfo = (ClientInfo) o;
    return Objects.equals(this.ip, clientInfo.ip) &&
        Objects.equals(this.fingerprint, clientInfo.fingerprint);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ip, fingerprint);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientInfo {\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

