package dev.vality.swag_webhook_events.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * BankCardDetails
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-08-08T11:27:10.986689983Z[Etc/UTC]")
public class BankCardDetails   {

  @JsonProperty("bin")
  private String bin;

  @JsonProperty("lastDigits")
  private String lastDigits;

  @JsonProperty("cardNumberMask")
  private String cardNumberMask;

  @JsonProperty("paymentSystem")
  private String paymentSystem;

  /**
   * Payment token provider
   */
  public enum TokenProviderEnum {
    APPLEPAY("applepay"),
    
    GOOGLEPAY("googlepay"),
    
    SAMSUNGPAY("samsungpay"),
    
    YANDEXPAY("yandexpay"),
    
    UNKNOWN("unknown");

    private String value;

    TokenProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TokenProviderEnum fromValue(String value) {
      for (TokenProviderEnum b : TokenProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("tokenProvider")
  private TokenProviderEnum tokenProvider;

  @JsonProperty("tokenProviderName")
  private String tokenProviderName;

  @JsonProperty("issuerCountry")
  private String issuerCountry;

  @JsonProperty("bankName")
  private String bankName;

  public BankCardDetails bin(String bin) {
    this.bin = bin;
    return this;
  }

  /**
   * Card issuing bank BIN
   * @return bin
  */
  @NotNull @Pattern(regexp = "^\\d{6,8}$") 
  @Schema(name = "bin", description = "Card issuing bank BIN", required = true)
  public String getBin() {
    return bin;
  }

  public void setBin(String bin) {
    this.bin = bin;
  }

  public BankCardDetails lastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
    return this;
  }

  /**
   * Card last digits
   * @return lastDigits
  */
  @NotNull @Pattern(regexp = "^\\d{2,4}$") 
  @Schema(name = "lastDigits", description = "Card last digits", required = true)
  public String getLastDigits() {
    return lastDigits;
  }

  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }

  public BankCardDetails cardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
    return this;
  }

  /**
   * Masked card number
   * @return cardNumberMask
  */
  @NotNull @Pattern(regexp = "^\\d{6,8}\\*+\\d{2,4}$") 
  @Schema(name = "cardNumberMask", description = "Masked card number", required = true)
  public String getCardNumberMask() {
    return cardNumberMask;
  }

  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }

  public BankCardDetails paymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
    return this;
  }

  /**
   * Payment system
   * @return paymentSystem
  */
  @NotNull @Size(max = 100) 
  @Schema(name = "paymentSystem", description = "Payment system", required = true)
  public String getPaymentSystem() {
    return paymentSystem;
  }

  public void setPaymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
  }

  public BankCardDetails tokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
    return this;
  }

  /**
   * Payment token provider
   * @return tokenProvider
  */
  
  @Schema(name = "tokenProvider", description = "Payment token provider", required = false)
  public TokenProviderEnum getTokenProvider() {
    return tokenProvider;
  }

  public void setTokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
  }

  public BankCardDetails tokenProviderName(String tokenProviderName) {
    this.tokenProviderName = tokenProviderName;
    return this;
  }

  /**
   * Payment token provider
   * @return tokenProviderName
  */
  
  @Schema(name = "tokenProviderName", description = "Payment token provider", required = false)
  public String getTokenProviderName() {
    return tokenProviderName;
  }

  public void setTokenProviderName(String tokenProviderName) {
    this.tokenProviderName = tokenProviderName;
  }

  public BankCardDetails issuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
    return this;
  }

  /**
   * Issuing country (alpha-3 code according to ISO_3166-1)
   * @return issuerCountry
  */
  
  @Schema(name = "issuerCountry", example = "[\"RUS\",\"POL\",\"USA\"]", description = "Issuing country (alpha-3 code according to ISO_3166-1)", required = false)
  public String getIssuerCountry() {
    return issuerCountry;
  }

  public void setIssuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
  }

  public BankCardDetails bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

  /**
   * Bank name
   * @return bankName
  */
  
  @Schema(name = "bankName", example = "[\"SBERBANK OF RUSSIA\",\"JOINT STOCK COMPANY ALFA-BANK\",\"VTB BANK OJSC\"]", description = "Bank name", required = false)
  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankCardDetails bankCardDetails = (BankCardDetails) o;
    return Objects.equals(this.bin, bankCardDetails.bin) &&
        Objects.equals(this.lastDigits, bankCardDetails.lastDigits) &&
        Objects.equals(this.cardNumberMask, bankCardDetails.cardNumberMask) &&
        Objects.equals(this.paymentSystem, bankCardDetails.paymentSystem) &&
        Objects.equals(this.tokenProvider, bankCardDetails.tokenProvider) &&
        Objects.equals(this.tokenProviderName, bankCardDetails.tokenProviderName) &&
        Objects.equals(this.issuerCountry, bankCardDetails.issuerCountry) &&
        Objects.equals(this.bankName, bankCardDetails.bankName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bin, lastDigits, cardNumberMask, paymentSystem, tokenProvider, tokenProviderName, issuerCountry, bankName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankCardDetails {\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("    tokenProviderName: ").append(toIndentedString(tokenProviderName)).append("\n");
    sb.append("    issuerCountry: ").append(toIndentedString(issuerCountry)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

