/*
 * Vality Webhooks Events API
 * ## Payment Webhook Events API  The specification defines a protocol for delivering notifications about new payment events within your organisation. The notifications are deliveried by the system as HTTP requests to the URL of webhooks you created. Handlers for such kind of queries should be implemented on the side of your server code according to the specification.  Webhook is a subscription to a specific type of event or group of events relating to different objects within your organisation. API methods described in the specification [Payment Webhook Management API](https://github.com/valitydev/swag-payments) are used to manage webhooks.  When within the wallet one of the events occurs (e.g. a wallet status change), the system selects a webhook matching that event type and sends an HTTP request containing a JSON message to the URL specified in the webhook. If several webhooks matching this event type were created, the event is simultaneously delivered to all URLs specified in those webhooks in an undefined order. ## Delivery strategy The system guarantees events delivery order within a specific notification subject (invoice, payment, refund, etc.). The system maintains a message queue for each notification item to keep the sequence and ensure the guaranteed delivery.  A delivery request is considered to be successful only when a response with status `200` is received. The system will wait for a successful response to the sent a request during 10 seconds. In case of a response with any other status or after expiration of the specified time which was reserved to process the notification, the system will try to re-deliver notifications until a successful response is received, or until a decision is made that it is impossible to deliver information. Delivery attempts will be made at the following time intervals between requests:    - 30 seconds,    - 5 minutes,    - 15 minutes,    - 1 hour.    - every hour within 24 hours  If the last attempt of notification delivery fails, all the events that have been accumulated in this payment queue are discarded. ## Received messages authorization The system confirms notifications authenticity by signing messages with a private key that is unique to each webhook, the paired public key of which is contained in the data of that webhook. The signature is transmitted in the HTTP header Content-Signature. Represented in various atributes the header contains the information about the algorithm used to create a signature and content of the signature in the format [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  At the moment the only one signature generation alorithm is possible to use. ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3) The signature is generated according to [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2) algorithm , which itself uses result of message [SHA-256](https://tools.ietf.org/html/rfc6234) calculation.  The set of header attributes and the list of possible signature generation algorithms can be expanded later. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.BankCardDetails;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import dev.vality.swag_webhook_events.model.PaymentToolDetailsBankCard;
import dev.vality.swag_webhook_events.model.PaymentToolDetailsCryptoWallet;
import dev.vality.swag_webhook_events.model.PaymentToolDetailsDigitalWallet;
import dev.vality.swag_webhook_events.model.PaymentToolDetailsMobileCommerce;
import dev.vality.swag_webhook_events.model.PaymentToolDetailsPaymentTerminal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * PaymentToolDetailsBankCard
 */
@JsonPropertyOrder({
  PaymentToolDetailsBankCard.JSON_PROPERTY_BIN,
  PaymentToolDetailsBankCard.JSON_PROPERTY_LAST_DIGITS,
  PaymentToolDetailsBankCard.JSON_PROPERTY_CARD_NUMBER_MASK,
  PaymentToolDetailsBankCard.JSON_PROPERTY_PAYMENT_SYSTEM,
  PaymentToolDetailsBankCard.JSON_PROPERTY_TOKEN_PROVIDER,
  PaymentToolDetailsBankCard.JSON_PROPERTY_TOKEN_PROVIDER_NAME,
  PaymentToolDetailsBankCard.JSON_PROPERTY_ISSUER_COUNTRY,
  PaymentToolDetailsBankCard.JSON_PROPERTY_BANK_NAME
})
@JsonTypeName("PaymentToolDetailsBankCard")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-08T11:21:50.147318634Z[Etc/UTC]")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "detailsType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = PaymentToolDetailsBankCard.class, name = "PaymentToolDetailsBankCard"),
  @JsonSubTypes.Type(value = PaymentToolDetailsCryptoWallet.class, name = "PaymentToolDetailsCryptoWallet"),
  @JsonSubTypes.Type(value = PaymentToolDetailsDigitalWallet.class, name = "PaymentToolDetailsDigitalWallet"),
  @JsonSubTypes.Type(value = PaymentToolDetailsMobileCommerce.class, name = "PaymentToolDetailsMobileCommerce"),
  @JsonSubTypes.Type(value = PaymentToolDetailsPaymentTerminal.class, name = "PaymentToolDetailsPaymentTerminal"),
})

public class PaymentToolDetailsBankCard extends PaymentToolDetails {
  public static final String JSON_PROPERTY_BIN = "bin";
  private String bin;

  public static final String JSON_PROPERTY_LAST_DIGITS = "lastDigits";
  private String lastDigits;

  public static final String JSON_PROPERTY_CARD_NUMBER_MASK = "cardNumberMask";
  private String cardNumberMask;

  public static final String JSON_PROPERTY_PAYMENT_SYSTEM = "paymentSystem";
  private String paymentSystem;

  /**
   * Payment token provider
   */
  public enum TokenProviderEnum {
    APPLEPAY("applepay"),
    
    GOOGLEPAY("googlepay"),
    
    SAMSUNGPAY("samsungpay"),
    
    YANDEXPAY("yandexpay"),
    
    UNKNOWN("unknown");

    private String value;

    TokenProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TokenProviderEnum fromValue(String value) {
      for (TokenProviderEnum b : TokenProviderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TOKEN_PROVIDER = "tokenProvider";
  private TokenProviderEnum tokenProvider;

  public static final String JSON_PROPERTY_TOKEN_PROVIDER_NAME = "tokenProviderName";
  private String tokenProviderName;

  public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
  private String issuerCountry;

  public static final String JSON_PROPERTY_BANK_NAME = "bankName";
  private String bankName;

  public PaymentToolDetailsBankCard() { 
  }

  public PaymentToolDetailsBankCard bin(String bin) {
    
    this.bin = bin;
    return this;
  }

   /**
   * Card issuing bank BIN
   * @return bin
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Card issuing bank BIN")
  @JsonProperty(JSON_PROPERTY_BIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBin() {
    return bin;
  }


  @JsonProperty(JSON_PROPERTY_BIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBin(String bin) {
    this.bin = bin;
  }


  public PaymentToolDetailsBankCard lastDigits(String lastDigits) {
    
    this.lastDigits = lastDigits;
    return this;
  }

   /**
   * Card last digits
   * @return lastDigits
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Card last digits")
  @JsonProperty(JSON_PROPERTY_LAST_DIGITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLastDigits() {
    return lastDigits;
  }


  @JsonProperty(JSON_PROPERTY_LAST_DIGITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }


  public PaymentToolDetailsBankCard cardNumberMask(String cardNumberMask) {
    
    this.cardNumberMask = cardNumberMask;
    return this;
  }

   /**
   * Masked card number
   * @return cardNumberMask
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Masked card number")
  @JsonProperty(JSON_PROPERTY_CARD_NUMBER_MASK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCardNumberMask() {
    return cardNumberMask;
  }


  @JsonProperty(JSON_PROPERTY_CARD_NUMBER_MASK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }


  public PaymentToolDetailsBankCard paymentSystem(String paymentSystem) {
    
    this.paymentSystem = paymentSystem;
    return this;
  }

   /**
   * Payment system
   * @return paymentSystem
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Payment system")
  @JsonProperty(JSON_PROPERTY_PAYMENT_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentSystem() {
    return paymentSystem;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentSystem(String paymentSystem) {
    this.paymentSystem = paymentSystem;
  }


  public PaymentToolDetailsBankCard tokenProvider(TokenProviderEnum tokenProvider) {
    
    this.tokenProvider = tokenProvider;
    return this;
  }

   /**
   * Payment token provider
   * @return tokenProvider
   * @deprecated
  **/
  @Deprecated
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Payment token provider")
  @JsonProperty(JSON_PROPERTY_TOKEN_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TokenProviderEnum getTokenProvider() {
    return tokenProvider;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
  }


  public PaymentToolDetailsBankCard tokenProviderName(String tokenProviderName) {
    
    this.tokenProviderName = tokenProviderName;
    return this;
  }

   /**
   * Payment token provider
   * @return tokenProviderName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Payment token provider")
  @JsonProperty(JSON_PROPERTY_TOKEN_PROVIDER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTokenProviderName() {
    return tokenProviderName;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_PROVIDER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenProviderName(String tokenProviderName) {
    this.tokenProviderName = tokenProviderName;
  }


  public PaymentToolDetailsBankCard issuerCountry(String issuerCountry) {
    
    this.issuerCountry = issuerCountry;
    return this;
  }

   /**
   * Issuing country (alpha-3 code according to ISO_3166-1)
   * @return issuerCountry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"RUS\",\"POL\",\"USA\"]", value = "Issuing country (alpha-3 code according to ISO_3166-1)")
  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssuerCountry() {
    return issuerCountry;
  }


  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
  }


  public PaymentToolDetailsBankCard bankName(String bankName) {
    
    this.bankName = bankName;
    return this;
  }

   /**
   * Bank name
   * @return bankName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"SBERBANK OF RUSSIA\",\"JOINT STOCK COMPANY ALFA-BANK\",\"VTB BANK OJSC\"]", value = "Bank name")
  @JsonProperty(JSON_PROPERTY_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankName() {
    return bankName;
  }


  @JsonProperty(JSON_PROPERTY_BANK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankName(String bankName) {
    this.bankName = bankName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetailsBankCard paymentToolDetailsBankCard = (PaymentToolDetailsBankCard) o;
    return Objects.equals(this.bin, paymentToolDetailsBankCard.bin) &&
        Objects.equals(this.lastDigits, paymentToolDetailsBankCard.lastDigits) &&
        Objects.equals(this.cardNumberMask, paymentToolDetailsBankCard.cardNumberMask) &&
        Objects.equals(this.paymentSystem, paymentToolDetailsBankCard.paymentSystem) &&
        Objects.equals(this.tokenProvider, paymentToolDetailsBankCard.tokenProvider) &&
        Objects.equals(this.tokenProviderName, paymentToolDetailsBankCard.tokenProviderName) &&
        Objects.equals(this.issuerCountry, paymentToolDetailsBankCard.issuerCountry) &&
        Objects.equals(this.bankName, paymentToolDetailsBankCard.bankName) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bin, lastDigits, cardNumberMask, paymentSystem, tokenProvider, tokenProviderName, issuerCountry, bankName, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetailsBankCard {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("    tokenProviderName: ").append(toIndentedString(tokenProviderName)).append("\n");
    sb.append("    issuerCountry: ").append(toIndentedString(issuerCountry)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

