/*
 * Vality Webhooks Events API
 * ## Payment Webhook Events API  The specification defines a protocol for delivering notifications about new payment events within your organisation. The notifications are deliveried by the system as HTTP requests to the URL of webhooks you created. Handlers for such kind of queries should be implemented on the side of your server code according to the specification.  Webhook is a subscription to a specific type of event or group of events relating to different objects within your organisation. API methods described in the specification [Payment Webhook Management API](https://github.com/valitydev/swag-payments) are used to manage webhooks.  When within the wallet one of the events occurs (e.g. a wallet status change), the system selects a webhook matching that event type and sends an HTTP request containing a JSON message to the URL specified in the webhook. If several webhooks matching this event type were created, the event is simultaneously delivered to all URLs specified in those webhooks in an undefined order. ## Delivery strategy The system guarantees events delivery order within a specific notification subject (invoice, payment, refund, etc.). The system maintains a message queue for each notification item to keep the sequence and ensure the guaranteed delivery.  A delivery request is considered to be successful only when a response with status `200` is received. The system will wait for a successful response to the sent a request during 10 seconds. In case of a response with any other status or after expiration of the specified time which was reserved to process the notification, the system will try to re-deliver notifications until a successful response is received, or until a decision is made that it is impossible to deliver information. Delivery attempts will be made at the following time intervals between requests:    - 30 seconds,    - 5 minutes,    - 15 minutes,    - 1 hour.    - every hour within 24 hours  If the last attempt of notification delivery fails, all the events that have been accumulated in this payment queue are discarded. ## Received messages authorization The system confirms notifications authenticity by signing messages with a private key that is unique to each webhook, the paired public key of which is contained in the data of that webhook. The signature is transmitted in the HTTP header Content-Signature. Represented in various atributes the header contains the information about the algorithm used to create a signature and content of the signature in the format [URL-safe base-64](https://tools.ietf.org/html/rfc4648).  ``` Content-Signature: alg=RS256; digest=zFuf7bRH4RHwyktaqHQwmX5rn3LfSb4dKo... ```  At the moment the only one signature generation alorithm is possible to use. ### [RS256](https://tools.ietf.org/html/rfc7518#section-3.3) The signature is generated according to [RSASSA-PKCS1-v1_5](https://tools.ietf.org/html/rfc3447#section-8.2) algorithm , which itself uses result of message [SHA-256](https://tools.ietf.org/html/rfc6234) calculation.  The set of header attributes and the list of possible signature generation algorithms can be expanded later. 
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@vality.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package dev.vality.swag_webhook_events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Payer;
import dev.vality.swag_webhook_events.model.PaymentContactInfo;
import dev.vality.swag_webhook_events.model.PaymentError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Invoice payment data
 */
@ApiModel(description = "Invoice payment data")
@JsonPropertyOrder({
  Payment.JSON_PROPERTY_ID,
  Payment.JSON_PROPERTY_CREATED_AT,
  Payment.JSON_PROPERTY_STATUS,
  Payment.JSON_PROPERTY_ERROR,
  Payment.JSON_PROPERTY_AMOUNT,
  Payment.JSON_PROPERTY_CURRENCY,
  Payment.JSON_PROPERTY_METADATA,
  Payment.JSON_PROPERTY_PAYMENT_TOOL_TOKEN,
  Payment.JSON_PROPERTY_PAYMENT_SESSION,
  Payment.JSON_PROPERTY_CONTACT_INFO,
  Payment.JSON_PROPERTY_IP,
  Payment.JSON_PROPERTY_FINGERPRINT,
  Payment.JSON_PROPERTY_PAYER,
  Payment.JSON_PROPERTY_FEE,
  Payment.JSON_PROPERTY_RRN,
  Payment.JSON_PROPERTY_EXTERNAL_ID
})
@JsonTypeName("Payment")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-08T11:12:56.756449482Z[Etc/UTC]")
public class Payment {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  /**
   * Payment status
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    PROCESSED("processed"),
    
    CAPTURED("captured"),
    
    CANCELLED("cancelled"),
    
    REFUNDED("refunded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_ERROR = "error";
  private PaymentError error;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Long amount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Object metadata;

  public static final String JSON_PROPERTY_PAYMENT_TOOL_TOKEN = "paymentToolToken";
  private String paymentToolToken;

  public static final String JSON_PROPERTY_PAYMENT_SESSION = "paymentSession";
  private String paymentSession;

  public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
  private PaymentContactInfo contactInfo;

  public static final String JSON_PROPERTY_IP = "ip";
  private String ip;

  public static final String JSON_PROPERTY_FINGERPRINT = "fingerprint";
  private String fingerprint;

  public static final String JSON_PROPERTY_PAYER = "payer";
  private Payer payer;

  public static final String JSON_PROPERTY_FEE = "fee";
  private Long fee;

  public static final String JSON_PROPERTY_RRN = "rrn";
  private String rrn;

  public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
  private String externalId;

  public Payment() { 
  }

  public Payment id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Payment ID
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Payment ID")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public Payment createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Date and time of creation
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Date and time of creation")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Payment status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Payment status
   * @return status
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Payment status")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Payment error(PaymentError error) {
    
    this.error = error;
    return this;
  }

   /**
   * Get error
   * @return error
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentError getError() {
    return error;
  }


  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setError(PaymentError error) {
    this.error = error;
  }


  public Payment amount(Long amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * The price of the goods or services offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency 
   * minimum: 1
   * @return amount
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "The price of the goods or services offered, in minor monetary units, e.g. cents if U.S. dollars are specified as the currency ")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(Long amount) {
    this.amount = amount;
  }


  public Payment currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). 
   * @return currency
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Currency character code according to [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Payment metadata(Object metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Payment metadata
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Payment metadata")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  public Payment paymentToolToken(String paymentToolToken) {
    
    this.paymentToolToken = paymentToolToken;
    return this;
  }

   /**
   * **Deprecated.** _Use the &#x60;payer&#x60; property._  Payment tool token 
   * @return paymentToolToken
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "**Deprecated.** _Use the `payer` property._  Payment tool token ")
  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentToolToken() {
    return paymentToolToken;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_TOOL_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }


  public Payment paymentSession(String paymentSession) {
    
    this.paymentSession = paymentSession;
    return this;
  }

   /**
   * **Deprecated.** _Use the &#x60;payer&#x60; property._  Payment session identifier 
   * @return paymentSession
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "**Deprecated.** _Use the `payer` property._  Payment session identifier ")
  @JsonProperty(JSON_PROPERTY_PAYMENT_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentSession() {
    return paymentSession;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }


  public Payment contactInfo(PaymentContactInfo contactInfo) {
    
    this.contactInfo = contactInfo;
    return this;
  }

   /**
   * Get contactInfo
   * @return contactInfo
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PaymentContactInfo getContactInfo() {
    return contactInfo;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactInfo(PaymentContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }


  public Payment ip(String ip) {
    
    this.ip = ip;
    return this;
  }

   /**
   * **Deprecated.** _Use the &#x60;payer&#x60; property._  Payer&#39;s IP-address 
   * @return ip
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "**Deprecated.** _Use the `payer` property._  Payer's IP-address ")
  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIp() {
    return ip;
  }


  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIp(String ip) {
    this.ip = ip;
  }


  public Payment fingerprint(String fingerprint) {
    
    this.fingerprint = fingerprint;
    return this;
  }

   /**
   * **Deprecated.** _Use the &#x60;payer&#x60; property._  Payer&#39;s fingerprint 
   * @return fingerprint
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "**Deprecated.** _Use the `payer` property._  Payer's fingerprint ")
  @JsonProperty(JSON_PROPERTY_FINGERPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFingerprint() {
    return fingerprint;
  }


  @JsonProperty(JSON_PROPERTY_FINGERPRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
  }


  public Payment payer(Payer payer) {
    
    this.payer = payer;
    return this;
  }

   /**
   * Get payer
   * @return payer
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Payer getPayer() {
    return payer;
  }


  @JsonProperty(JSON_PROPERTY_PAYER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayer(Payer payer) {
    this.payer = payer;
  }


  public Payment fee(Long fee) {
    
    this.fee = fee;
    return this;
  }

   /**
   * System fee in minor monetary units. 
   * @return fee
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "System fee in minor monetary units. ")
  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFee() {
    return fee;
  }


  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFee(Long fee) {
    this.fee = fee;
  }


  public Payment rrn(String rrn) {
    
    this.rrn = rrn;
    return this;
  }

   /**
   * Retrieval reference number 
   * @return rrn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Retrieval reference number ")
  @JsonProperty(JSON_PROPERTY_RRN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRrn() {
    return rrn;
  }


  @JsonProperty(JSON_PROPERTY_RRN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRrn(String rrn) {
    this.rrn = rrn;
  }


  public Payment externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

   /**
   * Merchant&#39;s transaction identifier
   * @return externalId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Merchant's transaction identifier")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalId() {
    return externalId;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payment payment = (Payment) o;
    return Objects.equals(this.id, payment.id) &&
        Objects.equals(this.createdAt, payment.createdAt) &&
        Objects.equals(this.status, payment.status) &&
        Objects.equals(this.error, payment.error) &&
        Objects.equals(this.amount, payment.amount) &&
        Objects.equals(this.currency, payment.currency) &&
        Objects.equals(this.metadata, payment.metadata) &&
        Objects.equals(this.paymentToolToken, payment.paymentToolToken) &&
        Objects.equals(this.paymentSession, payment.paymentSession) &&
        Objects.equals(this.contactInfo, payment.contactInfo) &&
        Objects.equals(this.ip, payment.ip) &&
        Objects.equals(this.fingerprint, payment.fingerprint) &&
        Objects.equals(this.payer, payment.payer) &&
        Objects.equals(this.fee, payment.fee) &&
        Objects.equals(this.rrn, payment.rrn) &&
        Objects.equals(this.externalId, payment.externalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, status, error, amount, currency, metadata, paymentToolToken, paymentSession, contactInfo, ip, fingerprint, payer, fee, rrn, externalId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payment {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
    sb.append("    payer: ").append(toIndentedString(payer)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    rrn: ").append(toIndentedString(rrn)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

