/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.CustomerBindingFailed;
import dev.vality.swag_webhook_events.model.CustomerBindingStarted;
import dev.vality.swag_webhook_events.model.CustomerBindingSucceeded;
import dev.vality.swag_webhook_events.model.CustomerCreated;
import dev.vality.swag_webhook_events.model.CustomerDeleted;
import dev.vality.swag_webhook_events.model.CustomerReady;
import dev.vality.swag_webhook_events.model.InvoiceCancelled;
import dev.vality.swag_webhook_events.model.InvoiceCreated;
import dev.vality.swag_webhook_events.model.InvoiceFulfilled;
import dev.vality.swag_webhook_events.model.InvoicePaid;
import dev.vality.swag_webhook_events.model.PaymentCancelled;
import dev.vality.swag_webhook_events.model.PaymentCaptured;
import dev.vality.swag_webhook_events.model.PaymentFailed;
import dev.vality.swag_webhook_events.model.PaymentProcessed;
import dev.vality.swag_webhook_events.model.PaymentRefunded;
import dev.vality.swag_webhook_events.model.PaymentStarted;
import dev.vality.swag_webhook_events.model.RefundCreated;
import dev.vality.swag_webhook_events.model.RefundFailed;
import dev.vality.swag_webhook_events.model.RefundPending;
import dev.vality.swag_webhook_events.model.RefundSucceeded;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Event data")
@JsonPropertyOrder(value={"eventID", "occuredAt", "topic", "eventType"})
@JsonTypeName(value="Event")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="eventType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CustomerBindingFailed.class, name="CustomerBindingFailed"), @JsonSubTypes.Type(value=CustomerBindingStarted.class, name="CustomerBindingStarted"), @JsonSubTypes.Type(value=CustomerBindingSucceeded.class, name="CustomerBindingSucceeded"), @JsonSubTypes.Type(value=CustomerCreated.class, name="CustomerCreated"), @JsonSubTypes.Type(value=CustomerDeleted.class, name="CustomerDeleted"), @JsonSubTypes.Type(value=CustomerReady.class, name="CustomerReady"), @JsonSubTypes.Type(value=InvoiceCancelled.class, name="InvoiceCancelled"), @JsonSubTypes.Type(value=InvoiceCreated.class, name="InvoiceCreated"), @JsonSubTypes.Type(value=InvoiceFulfilled.class, name="InvoiceFulfilled"), @JsonSubTypes.Type(value=InvoicePaid.class, name="InvoicePaid"), @JsonSubTypes.Type(value=PaymentCancelled.class, name="PaymentCancelled"), @JsonSubTypes.Type(value=PaymentCaptured.class, name="PaymentCaptured"), @JsonSubTypes.Type(value=PaymentFailed.class, name="PaymentFailed"), @JsonSubTypes.Type(value=PaymentProcessed.class, name="PaymentProcessed"), @JsonSubTypes.Type(value=PaymentRefunded.class, name="PaymentRefunded"), @JsonSubTypes.Type(value=PaymentStarted.class, name="PaymentStarted"), @JsonSubTypes.Type(value=RefundCreated.class, name="RefundCreated"), @JsonSubTypes.Type(value=RefundFailed.class, name="RefundFailed"), @JsonSubTypes.Type(value=RefundPending.class, name="RefundPending"), @JsonSubTypes.Type(value=RefundSucceeded.class, name="RefundSucceeded")})
public class Event {
    public static final String JSON_PROPERTY_EVENT_I_D = "eventID";
    private Integer eventID;
    public static final String JSON_PROPERTY_OCCURED_AT = "occuredAt";
    private OffsetDateTime occuredAt;
    public static final String JSON_PROPERTY_TOPIC = "topic";
    private TopicEnum topic;
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    protected EventTypeEnum eventType;

    public Event eventID(Integer eventID) {
        this.eventID = eventID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Event identifier")
    @JsonProperty(value="eventID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getEventID() {
        return this.eventID;
    }

    @JsonProperty(value="eventID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventID(Integer eventID) {
        this.eventID = eventID;
    }

    public Event occuredAt(OffsetDateTime occuredAt) {
        this.occuredAt = occuredAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Date and time the event occurrence")
    @JsonProperty(value="occuredAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getOccuredAt() {
        return this.occuredAt;
    }

    @JsonProperty(value="occuredAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOccuredAt(OffsetDateTime occuredAt) {
        this.occuredAt = occuredAt;
    }

    public Event topic(TopicEnum topic) {
        this.topic = topic;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Subject of notification")
    @JsonProperty(value="topic")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TopicEnum getTopic() {
        return this.topic;
    }

    @JsonProperty(value="topic")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTopic(TopicEnum topic) {
        this.topic = topic;
    }

    public Event eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of event that occurred")
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.eventID, event.eventID) && Objects.equals(this.occuredAt, event.occuredAt) && Objects.equals((Object)this.topic, (Object)event.topic) && Objects.equals((Object)this.eventType, (Object)event.eventType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventID, this.occuredAt, this.topic, this.eventType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    eventID: ").append(this.toIndentedString(this.eventID)).append("\n");
        sb.append("    occuredAt: ").append(this.toIndentedString(this.occuredAt)).append("\n");
        sb.append("    topic: ").append(this.toIndentedString((Object)this.topic)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TopicEnum {
        INVOICESTOPIC("InvoicesTopic"),
        CUSTOMERSTOPIC("CustomersTopic");

        private String value;

        private TopicEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TopicEnum fromValue(String value) {
            for (TopicEnum b : TopicEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EventTypeEnum {
        INVOICECREATED("InvoiceCreated"),
        INVOICEPAID("InvoicePaid"),
        INVOICECANCELLED("InvoiceCancelled"),
        INVOICEFULFILLED("InvoiceFulfilled"),
        PAYMENTSTARTED("PaymentStarted"),
        PAYMENTPROCESSED("PaymentProcessed"),
        PAYMENTCAPTURED("PaymentCaptured"),
        PAYMENTCANCELLED("PaymentCancelled"),
        PAYMENTREFUNDED("PaymentRefunded"),
        PAYMENTFAILED("PaymentFailed"),
        REFUNDCREATED("RefundCreated"),
        REFUNDPENDING("RefundPending"),
        REFUNDSUCCEEDED("RefundSucceeded"),
        REFUNDFAILED("RefundFailed"),
        CUSTOMERCREATED("CustomerCreated"),
        CUSTOMERDELETED("CustomerDeleted"),
        CUSTOMERREADY("CustomerReady"),
        CUSTOMERBINDINGSTARTED("CustomerBindingStarted"),
        CUSTOMERBINDINGSUCCEEDED("CustomerBindingSucceeded"),
        CUSTOMERBINDINGFAILED("CustomerBindingFailed");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

