/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.PaymentToolDetails;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class PaymentToolDetailsBankCard
extends PaymentToolDetails {
    @JsonProperty(value="bin")
    private String bin;
    @JsonProperty(value="lastDigits")
    private String lastDigits;
    @JsonProperty(value="cardNumberMask")
    private String cardNumberMask;
    @JsonProperty(value="paymentSystem")
    private String paymentSystem;
    @JsonProperty(value="tokenProvider")
    private TokenProviderEnum tokenProvider;
    @JsonProperty(value="tokenProviderName")
    private String tokenProviderName;
    @JsonProperty(value="issuerCountry")
    private String issuerCountry;
    @JsonProperty(value="bankName")
    private String bankName;

    public PaymentToolDetailsBankCard bin(String bin) {
        this.bin = bin;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0411\u0418\u041d \u0431\u0430\u043d\u043a\u0430-\u044d\u043c\u0438\u0442\u0435\u043d\u0442\u0430 \u043a\u0430\u0440\u0442\u044b")
    @NotNull
    @Pattern(regexp="^\\d{6,8}$")
    public @NotNull @Pattern(regexp="^\\d{6,8}$") String getBin() {
        return this.bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public PaymentToolDetailsBankCard lastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
        return this;
    }

    @ApiModelProperty(required=true, value="\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0446\u0438\u0444\u0440\u044b \u043d\u043e\u043c\u0435\u0440\u0430 \u043a\u0430\u0440\u0442\u044b")
    @NotNull
    @Pattern(regexp="^\\d{2,4}$")
    public @NotNull @Pattern(regexp="^\\d{2,4}$") String getLastDigits() {
        return this.lastDigits;
    }

    public void setLastDigits(String lastDigits) {
        this.lastDigits = lastDigits;
    }

    public PaymentToolDetailsBankCard cardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
        return this;
    }

    @ApiModelProperty(required=true, value="\u041c\u0430\u0441\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b")
    @NotNull
    @Pattern(regexp="^\\d{6,8}\\*+\\d{2,4}$")
    public @NotNull @Pattern(regexp="^\\d{6,8}\\*+\\d{2,4}$") String getCardNumberMask() {
        return this.cardNumberMask;
    }

    public void setCardNumberMask(String cardNumberMask) {
        this.cardNumberMask = cardNumberMask;
    }

    public PaymentToolDetailsBankCard paymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
        return this;
    }

    @ApiModelProperty(required=true, value="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430")
    @NotNull
    @Size(max=100)
    public @NotNull @Size(max=100) String getPaymentSystem() {
        return this.paymentSystem;
    }

    public void setPaymentSystem(String paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public PaymentToolDetailsBankCard tokenProvider(TokenProviderEnum tokenProvider) {
        this.tokenProvider = tokenProvider;
        return this;
    }

    @ApiModelProperty(value="\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0445 \u0442\u043e\u043a\u0435\u043d\u043e\u0432")
    public TokenProviderEnum getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTokenProvider(TokenProviderEnum tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public PaymentToolDetailsBankCard tokenProviderName(String tokenProviderName) {
        this.tokenProviderName = tokenProviderName;
        return this;
    }

    @ApiModelProperty(value="\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0445 \u0442\u043e\u043a\u0435\u043d\u043e\u0432")
    public String getTokenProviderName() {
        return this.tokenProviderName;
    }

    public void setTokenProviderName(String tokenProviderName) {
        this.tokenProviderName = tokenProviderName;
    }

    public PaymentToolDetailsBankCard issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @ApiModelProperty(example="[\"RUS\",\"POL\",\"USA\"]", value="\u0421\u0442\u0440\u0430\u043d\u0430 \u044d\u043c\u0438\u0442\u0435\u043d\u0442 (alpha-3 \u043a\u043e\u0434 \u043f\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0443 ISO_3166-1)")
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public PaymentToolDetailsBankCard bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @ApiModelProperty(example="[\"SBERBANK OF RUSSIA\",\"JOINT STOCK COMPANY ALFA-BANK\",\"VTB BANK OJSC\"]", value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u0430")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentToolDetailsBankCard paymentToolDetailsBankCard = (PaymentToolDetailsBankCard)o;
        return Objects.equals(this.bin, paymentToolDetailsBankCard.bin) && Objects.equals(this.lastDigits, paymentToolDetailsBankCard.lastDigits) && Objects.equals(this.cardNumberMask, paymentToolDetailsBankCard.cardNumberMask) && Objects.equals(this.paymentSystem, paymentToolDetailsBankCard.paymentSystem) && Objects.equals((Object)this.tokenProvider, (Object)paymentToolDetailsBankCard.tokenProvider) && Objects.equals(this.tokenProviderName, paymentToolDetailsBankCard.tokenProviderName) && Objects.equals(this.issuerCountry, paymentToolDetailsBankCard.issuerCountry) && Objects.equals(this.bankName, paymentToolDetailsBankCard.bankName) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.bin, this.lastDigits, this.cardNumberMask, this.paymentSystem, this.tokenProvider, this.tokenProviderName, this.issuerCountry, this.bankName, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentToolDetailsBankCard {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    lastDigits: ").append(this.toIndentedString(this.lastDigits)).append("\n");
        sb.append("    cardNumberMask: ").append(this.toIndentedString(this.cardNumberMask)).append("\n");
        sb.append("    paymentSystem: ").append(this.toIndentedString(this.paymentSystem)).append("\n");
        sb.append("    tokenProvider: ").append(this.toIndentedString((Object)this.tokenProvider)).append("\n");
        sb.append("    tokenProviderName: ").append(this.toIndentedString(this.tokenProviderName)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TokenProviderEnum {
        APPLEPAY("applepay"),
        GOOGLEPAY("googlepay"),
        SAMSUNGPAY("samsungpay"),
        YANDEXPAY("yandexpay"),
        UNKNOWN("unknown");

        private String value;

        private TokenProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenProviderEnum fromValue(String value) {
            for (TokenProviderEnum b : TokenProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

