/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag_webhook_events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag_webhook_events.model.Payer;
import dev.vality.swag_webhook_events.model.PaymentContactInfo;
import dev.vality.swag_webhook_events.model.PaymentError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel(description="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0438\u043d\u0432\u043e\u0439\u0441\u0430")
public class Payment {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="createdAt")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="error")
    private PaymentError error;
    @JsonProperty(value="amount")
    private Long amount;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="metadata")
    private Object metadata;
    @JsonProperty(value="paymentToolToken")
    private String paymentToolToken;
    @JsonProperty(value="paymentSession")
    private String paymentSession;
    @JsonProperty(value="contactInfo")
    private PaymentContactInfo contactInfo;
    @JsonProperty(value="ip")
    private String ip;
    @JsonProperty(value="fingerprint")
    private String fingerprint;
    @JsonProperty(value="payer")
    private Payer payer;
    @JsonProperty(value="fee")
    private Long fee;
    @JsonProperty(value="rrn")
    private String rrn;
    @JsonProperty(value="externalId")
    private String externalId;

    public Payment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Payment createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f")
    @NotNull
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Payment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    @NotNull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Payment error(PaymentError error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public PaymentError getError() {
        return this.error;
    }

    public void setError(PaymentError error) {
        this.error = error;
    }

    public Payment amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433, \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \u0432 \u043a\u043e\u043f\u0435\u0439\u043a\u0430\u0445 \u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0435\u0439 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0432\u0430\u043b\u044e\u0442\u044b. ")
    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Payment currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [RFC 4217](http://www.iso.org/iso/home/standards/currency_codes.htm). ")
    @NotNull
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Payment metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u043e\u043c \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Payment paymentToolToken(String paymentToolToken) {
        this.paymentToolToken = paymentToolToken;
        return this;
    }

    @ApiModelProperty(value="**Deprecated.** _\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e `payer`._ \u0422\u043e\u043a\u0435\u043d \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0433\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430, \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u043e\u043c ")
    public String getPaymentToolToken() {
        return this.paymentToolToken;
    }

    public void setPaymentToolToken(String paymentToolToken) {
        this.paymentToolToken = paymentToolToken;
    }

    public Payment paymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
        return this;
    }

    @ApiModelProperty(required=true, value="**Deprecated.** _\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e `payer`._ \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0441\u0435\u0441\u0441\u0438\u0438 ")
    @NotNull
    public String getPaymentSession() {
        return this.paymentSession;
    }

    public void setPaymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
    }

    public Payment contactInfo(PaymentContactInfo contactInfo) {
        this.contactInfo = contactInfo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public PaymentContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(PaymentContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    public Payment ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(value="**Deprecated.** _\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e `payer`._ IP-\u0430\u0434\u0440\u0435\u0441 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430 ")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Payment fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @ApiModelProperty(value="**Deprecated.** _\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e `payer`._ \u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043e\u0442\u043f\u0435\u0447\u0430\u0442\u043e\u043a user agent'\u0430 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430 ")
    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public Payment payer(Payer payer) {
        this.payer = payer;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public Payer getPayer() {
        return this.payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public Payment fee(Long fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(value="\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b, \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445. ")
    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Payment rrn(String rrn) {
        this.rrn = rrn;
        return this;
    }

    @ApiModelProperty(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u0438 \u0440\u0430\u0441\u0447\u0435\u0442\u043e\u0432 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u044e\u0449\u0435\u0433\u043e \u0431\u0430\u043d\u043a\u0430 ")
    public String getRrn() {
        return this.rrn;
    }

    public void setRrn(String rrn) {
        this.rrn = rrn;
    }

    public Payment externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0441\u043e \u0441\u0442\u043e\u0440\u043e\u043d\u044b \u043c\u0435\u0440\u0447\u0430\u043d\u0442\u0430")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.id, payment.id) && Objects.equals(this.createdAt, payment.createdAt) && Objects.equals((Object)this.status, (Object)payment.status) && Objects.equals(this.error, payment.error) && Objects.equals(this.amount, payment.amount) && Objects.equals(this.currency, payment.currency) && Objects.equals(this.metadata, payment.metadata) && Objects.equals(this.paymentToolToken, payment.paymentToolToken) && Objects.equals(this.paymentSession, payment.paymentSession) && Objects.equals(this.contactInfo, payment.contactInfo) && Objects.equals(this.ip, payment.ip) && Objects.equals(this.fingerprint, payment.fingerprint) && Objects.equals(this.payer, payment.payer) && Objects.equals(this.fee, payment.fee) && Objects.equals(this.rrn, payment.rrn) && Objects.equals(this.externalId, payment.externalId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdAt, this.status, this.error, this.amount, this.currency, this.metadata, this.paymentToolToken, this.paymentSession, this.contactInfo, this.ip, this.fingerprint, this.payer, this.fee, this.rrn, this.externalId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    paymentToolToken: ").append(this.toIndentedString(this.paymentToolToken)).append("\n");
        sb.append("    paymentSession: ").append(this.toIndentedString(this.paymentSession)).append("\n");
        sb.append("    contactInfo: ").append(this.toIndentedString(this.contactInfo)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("    payer: ").append(this.toIndentedString(this.payer)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    rrn: ").append(this.toIndentedString(this.rrn)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        PROCESSED("processed"),
        CAPTURED("captured"),
        CANCELLED("cancelled"),
        REFUNDED("refunded"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

